/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Message;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Readiness;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfMessageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleResult> {
    private static final SdkField<Instant> LAST_CHECKED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckedTimestamp").getter(RuleResult.getter(RuleResult::lastCheckedTimestamp)).setter(RuleResult.setter(Builder::lastCheckedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCheckedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(RuleResult.getter(RuleResult::messages)).setter(RuleResult.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> READINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Readiness").getter(RuleResult.getter(RuleResult::readinessAsString)).setter(RuleResult.setter(Builder::readiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(RuleResult.getter(RuleResult::ruleId)).setter(RuleResult.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_CHECKED_TIMESTAMP_FIELD, MESSAGES_FIELD, READINESS_FIELD, RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("lastCheckedTimestamp", LAST_CHECKED_TIMESTAMP_FIELD);
            this.put("messages", MESSAGES_FIELD);
            this.put("readiness", READINESS_FIELD);
            this.put("ruleId", RULE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant lastCheckedTimestamp;
    private final List<Message> messages;
    private final String readiness;
    private final String ruleId;

    private RuleResult(BuilderImpl builder) {
        this.lastCheckedTimestamp = builder.lastCheckedTimestamp;
        this.messages = builder.messages;
        this.readiness = builder.readiness;
        this.ruleId = builder.ruleId;
    }

    public final Instant lastCheckedTimestamp() {
        return this.lastCheckedTimestamp;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final Readiness readiness() {
        return Readiness.fromValue(this.readiness);
    }

    public final String readinessAsString() {
        return this.readiness;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        return Objects.equals(this.lastCheckedTimestamp(), other.lastCheckedTimestamp()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.readinessAsString(), other.readinessAsString()) && Objects.equals(this.ruleId(), other.ruleId());
    }

    public final String toString() {
        return ToString.builder((String)"RuleResult").add("LastCheckedTimestamp", (Object)this.lastCheckedTimestamp()).add("Messages", this.hasMessages() ? this.messages() : null).add("Readiness", (Object)this.readinessAsString()).add("RuleId", (Object)this.ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastCheckedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckedTimestamp()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "Readiness": {
                return Optional.ofNullable(clazz.cast(this.readinessAsString()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleResult, T> g) {
        return obj -> g.apply((RuleResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastCheckedTimestamp;
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private String readiness;
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleResult model) {
            this.lastCheckedTimestamp(model.lastCheckedTimestamp);
            this.messages(model.messages);
            this.readiness(model.readiness);
            this.ruleId(model.ruleId);
        }

        public final Instant getLastCheckedTimestamp() {
            return this.lastCheckedTimestamp;
        }

        public final void setLastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
        }

        @Override
        public final Builder lastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = ___listOfMessageCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = ___listOfMessageCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = ___listOfMessageCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReadiness() {
            return this.readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public RuleResult build() {
            return new RuleResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleResult> {
        public Builder lastCheckedTimestamp(Instant var1);

        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder readiness(String var1);

        public Builder readiness(Readiness var1);

        public Builder ruleId(String var1);
    }
}

