/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagsCopier;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecoveryGroupResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, UpdateRecoveryGroupResponse> {
    private static final SdkField<List<String>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cells").getter(UpdateRecoveryGroupResponse.getter(UpdateRecoveryGroupResponse::cells)).setter(UpdateRecoveryGroupResponse.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOVERY_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryGroupArn").getter(UpdateRecoveryGroupResponse.getter(UpdateRecoveryGroupResponse::recoveryGroupArn)).setter(UpdateRecoveryGroupResponse.setter(Builder::recoveryGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryGroupArn").build()}).build();
    private static final SdkField<String> RECOVERY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryGroupName").getter(UpdateRecoveryGroupResponse.getter(UpdateRecoveryGroupResponse::recoveryGroupName)).setter(UpdateRecoveryGroupResponse.setter(Builder::recoveryGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryGroupName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateRecoveryGroupResponse.getter(UpdateRecoveryGroupResponse::tags)).setter(UpdateRecoveryGroupResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD, RECOVERY_GROUP_ARN_FIELD, RECOVERY_GROUP_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cells", CELLS_FIELD);
            this.put("recoveryGroupArn", RECOVERY_GROUP_ARN_FIELD);
            this.put("recoveryGroupName", RECOVERY_GROUP_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final List<String> cells;
    private final String recoveryGroupArn;
    private final String recoveryGroupName;
    private final Map<String, String> tags;

    private UpdateRecoveryGroupResponse(BuilderImpl builder) {
        super(builder);
        this.cells = builder.cells;
        this.recoveryGroupArn = builder.recoveryGroupArn;
        this.recoveryGroupName = builder.recoveryGroupName;
        this.tags = builder.tags;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<String> cells() {
        return this.cells;
    }

    public final String recoveryGroupArn() {
        return this.recoveryGroupArn;
    }

    public final String recoveryGroupName() {
        return this.recoveryGroupName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryGroupResponse)) {
            return false;
        }
        UpdateRecoveryGroupResponse other = (UpdateRecoveryGroupResponse)((Object)obj);
        return this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells()) && Objects.equals(this.recoveryGroupArn(), other.recoveryGroupArn()) && Objects.equals(this.recoveryGroupName(), other.recoveryGroupName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecoveryGroupResponse").add("Cells", this.hasCells() ? this.cells() : null).add("RecoveryGroupArn", (Object)this.recoveryGroupArn()).add("RecoveryGroupName", (Object)this.recoveryGroupName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
            case "RecoveryGroupArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryGroupArn()));
            }
            case "RecoveryGroupName": {
                return Optional.ofNullable(clazz.cast(this.recoveryGroupName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryGroupResponse, T> g) {
        return obj -> g.apply((UpdateRecoveryGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private List<String> cells = DefaultSdkAutoConstructList.getInstance();
        private String recoveryGroupArn;
        private String recoveryGroupName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryGroupResponse model) {
            super(model);
            this.cells(model.cells);
            this.recoveryGroupArn(model.recoveryGroupArn);
            this.recoveryGroupName(model.recoveryGroupName);
            this.tags(model.tags);
        }

        public final Collection<String> getCells() {
            if (this.cells instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cells;
        }

        public final void setCells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
        }

        @Override
        public final Builder cells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(String ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        public final String getRecoveryGroupArn() {
            return this.recoveryGroupArn;
        }

        public final void setRecoveryGroupArn(String recoveryGroupArn) {
            this.recoveryGroupArn = recoveryGroupArn;
        }

        @Override
        public final Builder recoveryGroupArn(String recoveryGroupArn) {
            this.recoveryGroupArn = recoveryGroupArn;
            return this;
        }

        public final String getRecoveryGroupName() {
            return this.recoveryGroupName;
        }

        public final void setRecoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
        }

        @Override
        public final Builder recoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateRecoveryGroupResponse build() {
            return new UpdateRecoveryGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecoveryGroupResponse> {
        public Builder cells(Collection<String> var1);

        public Builder cells(String ... var1);

        public Builder recoveryGroupArn(String var1);

        public Builder recoveryGroupName(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

