/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadinessCheckResourceStatusRequest
extends Route53RecoveryReadinessRequest
implements ToCopyableBuilder<Builder, GetReadinessCheckResourceStatusRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetReadinessCheckResourceStatusRequest.getter(GetReadinessCheckResourceStatusRequest::maxResults)).setter(GetReadinessCheckResourceStatusRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetReadinessCheckResourceStatusRequest.getter(GetReadinessCheckResourceStatusRequest::nextToken)).setter(GetReadinessCheckResourceStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckName").getter(GetReadinessCheckResourceStatusRequest.getter(GetReadinessCheckResourceStatusRequest::readinessCheckName)).setter(GetReadinessCheckResourceStatusRequest.setter(Builder::readinessCheckName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("readinessCheckName").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(GetReadinessCheckResourceStatusRequest.getter(GetReadinessCheckResourceStatusRequest::resourceIdentifier)).setter(GetReadinessCheckResourceStatusRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, READINESS_CHECK_NAME_FIELD, RESOURCE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("readinessCheckName", READINESS_CHECK_NAME_FIELD);
            this.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        }
    });
    private final Integer maxResults;
    private final String nextToken;
    private final String readinessCheckName;
    private final String resourceIdentifier;

    private GetReadinessCheckResourceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String readinessCheckName() {
        return this.readinessCheckName;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckResourceStatusRequest)) {
            return false;
        }
        GetReadinessCheckResourceStatusRequest other = (GetReadinessCheckResourceStatusRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.readinessCheckName(), other.readinessCheckName()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadinessCheckResourceStatusRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ReadinessCheckName", (Object)this.readinessCheckName()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReadinessCheckName": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckName()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckResourceStatusRequest, T> g) {
        return obj -> g.apply((GetReadinessCheckResourceStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String readinessCheckName;
        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckResourceStatusRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.readinessCheckName(model.readinessCheckName);
            this.resourceIdentifier(model.resourceIdentifier);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReadinessCheckName() {
            return this.readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReadinessCheckResourceStatusRequest build() {
            return new GetReadinessCheckResourceStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadinessCheckResourceStatusRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder readinessCheckName(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

