/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Readiness rule information, including the resource type, rule ID, and rule description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRulesOutput implements SdkPojo, Serializable, ToCopyableBuilder<ListRulesOutput.Builder, ListRulesOutput> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListRulesOutput::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RULE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleDescription").getter(getter(ListRulesOutput::ruleDescription))
            .setter(setter(Builder::ruleDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDescription").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(ListRulesOutput::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RULE_DESCRIPTION_FIELD, RULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String ruleDescription;

    private final String ruleId;

    private ListRulesOutput(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.ruleDescription = builder.ruleDescription;
        this.ruleId = builder.ruleId;
    }

    /**
     * <p>
     * The resource type that the readiness rule applies to.
     * </p>
     * 
     * @return The resource type that the readiness rule applies to.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The description of a readiness rule.
     * </p>
     * 
     * @return The description of a readiness rule.
     */
    public final String ruleDescription() {
        return ruleDescription;
    }

    /**
     * <p>
     * The ID for the readiness rule.
     * </p>
     * 
     * @return The ID for the readiness rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesOutput)) {
            return false;
        }
        ListRulesOutput other = (ListRulesOutput) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(ruleDescription(), other.ruleDescription())
                && Objects.equals(ruleId(), other.ruleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRulesOutput").add("ResourceType", resourceType()).add("RuleDescription", ruleDescription())
                .add("RuleId", ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "RuleDescription":
            return Optional.ofNullable(clazz.cast(ruleDescription()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("ruleDescription", RULE_DESCRIPTION_FIELD);
        map.put("ruleId", RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRulesOutput, T> g) {
        return obj -> g.apply((ListRulesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListRulesOutput> {
        /**
         * <p>
         * The resource type that the readiness rule applies to.
         * </p>
         * 
         * @param resourceType
         *        The resource type that the readiness rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The description of a readiness rule.
         * </p>
         * 
         * @param ruleDescription
         *        The description of a readiness rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDescription(String ruleDescription);

        /**
         * <p>
         * The ID for the readiness rule.
         * </p>
         * 
         * @param ruleId
         *        The ID for the readiness rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String ruleDescription;

        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesOutput model) {
            resourceType(model.resourceType);
            ruleDescription(model.ruleDescription);
            ruleId(model.ruleId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getRuleDescription() {
            return ruleDescription;
        }

        public final void setRuleDescription(String ruleDescription) {
            this.ruleDescription = ruleDescription;
        }

        @Override
        public final Builder ruleDescription(String ruleDescription) {
            this.ruleDescription = ruleDescription;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public ListRulesOutput build() {
            return new ListRulesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
