/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Route 53 resource that a DNS target resource record points to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class R53ResourceRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<R53ResourceRecord.Builder, R53ResourceRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(R53ResourceRecord::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> RECORD_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordSetId").getter(getter(R53ResourceRecord::recordSetId)).setter(setter(Builder::recordSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            RECORD_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String recordSetId;

    private R53ResourceRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.recordSetId = builder.recordSetId;
    }

    /**
     * <p>
     * The DNS target domain name.
     * </p>
     * 
     * @return The DNS target domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The Route 53 Resource Record Set ID.
     * </p>
     * 
     * @return The Route 53 Resource Record Set ID.
     */
    public final String recordSetId() {
        return recordSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(recordSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof R53ResourceRecord)) {
            return false;
        }
        R53ResourceRecord other = (R53ResourceRecord) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(recordSetId(), other.recordSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("R53ResourceRecord").add("DomainName", domainName()).add("RecordSetId", recordSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "RecordSetId":
            return Optional.ofNullable(clazz.cast(recordSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("recordSetId", RECORD_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<R53ResourceRecord, T> g) {
        return obj -> g.apply((R53ResourceRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, R53ResourceRecord> {
        /**
         * <p>
         * The DNS target domain name.
         * </p>
         * 
         * @param domainName
         *        The DNS target domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The Route 53 Resource Record Set ID.
         * </p>
         * 
         * @param recordSetId
         *        The Route 53 Resource Record Set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSetId(String recordSetId);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String recordSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(R53ResourceRecord model) {
            domainName(model.domainName);
            recordSetId(model.recordSetId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getRecordSetId() {
            return recordSetId;
        }

        public final void setRecordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
        }

        @Override
        public final Builder recordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
            return this;
        }

        @Override
        public R53ResourceRecord build() {
            return new R53ResourceRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
