/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of all readiness check statuses in a recovery group, paginated in GetRecoveryGroupReadinessSummary and
 * GetCellReadinessSummary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadinessCheckSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadinessCheckSummary.Builder, ReadinessCheckSummary> {
    private static final SdkField<String> READINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Readiness").getter(getter(ReadinessCheckSummary::readinessAsString)).setter(setter(Builder::readiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()).build();

    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadinessCheckName").getter(getter(ReadinessCheckSummary::readinessCheckName))
            .setter(setter(Builder::readinessCheckName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_FIELD,
            READINESS_CHECK_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String readiness;

    private final String readinessCheckName;

    private ReadinessCheckSummary(BuilderImpl builder) {
        this.readiness = builder.readiness;
        this.readinessCheckName = builder.readinessCheckName;
    }

    /**
     * <p>
     * The readiness status of this readiness check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness status of this readiness check.
     * @see Readiness
     */
    public final Readiness readiness() {
        return Readiness.fromValue(readiness);
    }

    /**
     * <p>
     * The readiness status of this readiness check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness status of this readiness check.
     * @see Readiness
     */
    public final String readinessAsString() {
        return readiness;
    }

    /**
     * <p>
     * The name of a readiness check.
     * </p>
     * 
     * @return The name of a readiness check.
     */
    public final String readinessCheckName() {
        return readinessCheckName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readinessCheckName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadinessCheckSummary)) {
            return false;
        }
        ReadinessCheckSummary other = (ReadinessCheckSummary) obj;
        return Objects.equals(readinessAsString(), other.readinessAsString())
                && Objects.equals(readinessCheckName(), other.readinessCheckName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadinessCheckSummary").add("Readiness", readinessAsString())
                .add("ReadinessCheckName", readinessCheckName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Readiness":
            return Optional.ofNullable(clazz.cast(readinessAsString()));
        case "ReadinessCheckName":
            return Optional.ofNullable(clazz.cast(readinessCheckName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("readiness", READINESS_FIELD);
        map.put("readinessCheckName", READINESS_CHECK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadinessCheckSummary, T> g) {
        return obj -> g.apply((ReadinessCheckSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadinessCheckSummary> {
        /**
         * <p>
         * The readiness status of this readiness check.
         * </p>
         * 
         * @param readiness
         *        The readiness status of this readiness check.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(String readiness);

        /**
         * <p>
         * The readiness status of this readiness check.
         * </p>
         * 
         * @param readiness
         *        The readiness status of this readiness check.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(Readiness readiness);

        /**
         * <p>
         * The name of a readiness check.
         * </p>
         * 
         * @param readinessCheckName
         *        The name of a readiness check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessCheckName(String readinessCheckName);
    }

    static final class BuilderImpl implements Builder {
        private String readiness;

        private String readinessCheckName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadinessCheckSummary model) {
            readiness(model.readiness);
            readinessCheckName(model.readinessCheckName);
        }

        public final String getReadiness() {
            return readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final String getReadinessCheckName() {
            return readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        @Override
        public ReadinessCheckSummary build() {
            return new ReadinessCheckSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
