/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the application, typically containing multiple cells.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryGroupOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryGroupOutput.Builder, RecoveryGroupOutput> {
    private static final SdkField<List<String>> CELLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cells")
            .getter(getter(RecoveryGroupOutput::cells))
            .setter(setter(Builder::cells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOVERY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryGroupArn").getter(getter(RecoveryGroupOutput::recoveryGroupArn))
            .setter(setter(Builder::recoveryGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryGroupArn").build()).build();

    private static final SdkField<String> RECOVERY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryGroupName").getter(getter(RecoveryGroupOutput::recoveryGroupName))
            .setter(setter(Builder::recoveryGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryGroupName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RecoveryGroupOutput::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD,
            RECOVERY_GROUP_ARN_FIELD, RECOVERY_GROUP_NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> cells;

    private final String recoveryGroupArn;

    private final String recoveryGroupName;

    private final Map<String, String> tags;

    private RecoveryGroupOutput(BuilderImpl builder) {
        this.cells = builder.cells;
        this.recoveryGroupArn = builder.recoveryGroupArn;
        this.recoveryGroupName = builder.recoveryGroupName;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cells property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCells() {
        return cells != null && !(cells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of a cell's Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCells} method.
     * </p>
     * 
     * @return A list of a cell's Amazon Resource Names (ARNs).
     */
    public final List<String> cells() {
        return cells;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the recovery group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the recovery group.
     */
    public final String recoveryGroupArn() {
        return recoveryGroupArn;
    }

    /**
     * <p>
     * The name of the recovery group.
     * </p>
     * 
     * @return The name of the recovery group.
     */
    public final String recoveryGroupName() {
        return recoveryGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the recovery group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the recovery group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCells() ? cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recoveryGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryGroupOutput)) {
            return false;
        }
        RecoveryGroupOutput other = (RecoveryGroupOutput) obj;
        return hasCells() == other.hasCells() && Objects.equals(cells(), other.cells())
                && Objects.equals(recoveryGroupArn(), other.recoveryGroupArn())
                && Objects.equals(recoveryGroupName(), other.recoveryGroupName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryGroupOutput").add("Cells", hasCells() ? cells() : null)
                .add("RecoveryGroupArn", recoveryGroupArn()).add("RecoveryGroupName", recoveryGroupName())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cells":
            return Optional.ofNullable(clazz.cast(cells()));
        case "RecoveryGroupArn":
            return Optional.ofNullable(clazz.cast(recoveryGroupArn()));
        case "RecoveryGroupName":
            return Optional.ofNullable(clazz.cast(recoveryGroupName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cells", CELLS_FIELD);
        map.put("recoveryGroupArn", RECOVERY_GROUP_ARN_FIELD);
        map.put("recoveryGroupName", RECOVERY_GROUP_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryGroupOutput, T> g) {
        return obj -> g.apply((RecoveryGroupOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryGroupOutput> {
        /**
         * <p>
         * A list of a cell's Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param cells
         *        A list of a cell's Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Collection<String> cells);

        /**
         * <p>
         * A list of a cell's Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param cells
         *        A list of a cell's Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(String... cells);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the recovery group.
         * </p>
         * 
         * @param recoveryGroupArn
         *        The Amazon Resource Name (ARN) for the recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryGroupArn(String recoveryGroupArn);

        /**
         * <p>
         * The name of the recovery group.
         * </p>
         * 
         * @param recoveryGroupName
         *        The name of the recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryGroupName(String recoveryGroupName);

        /**
         * <p>
         * The tags associated with the recovery group.
         * </p>
         * 
         * @param tags
         *        The tags associated with the recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cells = DefaultSdkAutoConstructList.getInstance();

        private String recoveryGroupArn;

        private String recoveryGroupName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryGroupOutput model) {
            cells(model.cells);
            recoveryGroupArn(model.recoveryGroupArn);
            recoveryGroupName(model.recoveryGroupName);
            tags(model.tags);
        }

        public final Collection<String> getCells() {
            if (cells instanceof SdkAutoConstructList) {
                return null;
            }
            return cells;
        }

        public final void setCells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
        }

        @Override
        public final Builder cells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(String... cells) {
            cells(Arrays.asList(cells));
            return this;
        }

        public final String getRecoveryGroupArn() {
            return recoveryGroupArn;
        }

        public final void setRecoveryGroupArn(String recoveryGroupArn) {
            this.recoveryGroupArn = recoveryGroupArn;
        }

        @Override
        public final Builder recoveryGroupArn(String recoveryGroupArn) {
            this.recoveryGroupArn = recoveryGroupArn;
            return this;
        }

        public final String getRecoveryGroupName() {
            return recoveryGroupName;
        }

        public final void setRecoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
        }

        @Override
        public final Builder recoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public RecoveryGroupOutput build() {
            return new RecoveryGroupOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
