/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource element of a resource set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentId").getter(getter(Resource::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()).build();

    private static final SdkField<DNSTargetResource> DNS_TARGET_RESOURCE_FIELD = SdkField
            .<DNSTargetResource> builder(MarshallingType.SDK_POJO).memberName("DnsTargetResource")
            .getter(getter(Resource::dnsTargetResource)).setter(setter(Builder::dnsTargetResource))
            .constructor(DNSTargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsTargetResource").build()).build();

    private static final SdkField<List<String>> READINESS_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadinessScopes")
            .getter(getter(Resource::readinessScopes))
            .setter(setter(Builder::readinessScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Resource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            DNS_TARGET_RESOURCE_FIELD, READINESS_SCOPES_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final DNSTargetResource dnsTargetResource;

    private final List<String> readinessScopes;

    private final String resourceArn;

    private Resource(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.dnsTargetResource = builder.dnsTargetResource;
        this.readinessScopes = builder.readinessScopes;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The component identifier of the resource, generated when DNS target resource is used.
     * </p>
     * 
     * @return The component identifier of the resource, generated when DNS target resource is used.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The DNS target resource.
     * </p>
     * 
     * @return The DNS target resource.
     */
    public final DNSTargetResource dnsTargetResource() {
        return dnsTargetResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadinessScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadinessScopes() {
        return readinessScopes != null && !(readinessScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadinessScopes} method.
     * </p>
     * 
     * @return A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained
     *         within.
     */
    public final List<String> readinessScopes() {
        return readinessScopes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(dnsTargetResource());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadinessScopes() ? readinessScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(componentId(), other.componentId())
                && Objects.equals(dnsTargetResource(), other.dnsTargetResource())
                && hasReadinessScopes() == other.hasReadinessScopes()
                && Objects.equals(readinessScopes(), other.readinessScopes())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("ComponentId", componentId()).add("DnsTargetResource", dnsTargetResource())
                .add("ReadinessScopes", hasReadinessScopes() ? readinessScopes() : null).add("ResourceArn", resourceArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "DnsTargetResource":
            return Optional.ofNullable(clazz.cast(dnsTargetResource()));
        case "ReadinessScopes":
            return Optional.ofNullable(clazz.cast(readinessScopes()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentId", COMPONENT_ID_FIELD);
        map.put("dnsTargetResource", DNS_TARGET_RESOURCE_FIELD);
        map.put("readinessScopes", READINESS_SCOPES_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The component identifier of the resource, generated when DNS target resource is used.
         * </p>
         * 
         * @param componentId
         *        The component identifier of the resource, generated when DNS target resource is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The DNS target resource.
         * </p>
         * 
         * @param dnsTargetResource
         *        The DNS target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsTargetResource(DNSTargetResource dnsTargetResource);

        /**
         * <p>
         * The DNS target resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DNSTargetResource.Builder} avoiding the
         * need to create one manually via {@link DNSTargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DNSTargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsTargetResource(DNSTargetResource)}.
         * 
         * @param dnsTargetResource
         *        a consumer that will call methods on {@link DNSTargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsTargetResource(DNSTargetResource)
         */
        default Builder dnsTargetResource(Consumer<DNSTargetResource.Builder> dnsTargetResource) {
            return dnsTargetResource(DNSTargetResource.builder().applyMutation(dnsTargetResource).build());
        }

        /**
         * <p>
         * A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
         * </p>
         * 
         * @param readinessScopes
         *        A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained
         *        within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessScopes(Collection<String> readinessScopes);

        /**
         * <p>
         * A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
         * </p>
         * 
         * @param readinessScopes
         *        A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained
         *        within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessScopes(String... readinessScopes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private DNSTargetResource dnsTargetResource;

        private List<String> readinessScopes = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            componentId(model.componentId);
            dnsTargetResource(model.dnsTargetResource);
            readinessScopes(model.readinessScopes);
            resourceArn(model.resourceArn);
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final DNSTargetResource.Builder getDnsTargetResource() {
            return dnsTargetResource != null ? dnsTargetResource.toBuilder() : null;
        }

        public final void setDnsTargetResource(DNSTargetResource.BuilderImpl dnsTargetResource) {
            this.dnsTargetResource = dnsTargetResource != null ? dnsTargetResource.build() : null;
        }

        @Override
        public final Builder dnsTargetResource(DNSTargetResource dnsTargetResource) {
            this.dnsTargetResource = dnsTargetResource;
            return this;
        }

        public final Collection<String> getReadinessScopes() {
            if (readinessScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return readinessScopes;
        }

        public final void setReadinessScopes(Collection<String> readinessScopes) {
            this.readinessScopes = ___listOf__stringCopier.copy(readinessScopes);
        }

        @Override
        public final Builder readinessScopes(Collection<String> readinessScopes) {
            this.readinessScopes = ___listOf__stringCopier.copy(readinessScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessScopes(String... readinessScopes) {
            readinessScopes(Arrays.asList(readinessScopes));
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
