/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target resource that the Route 53 record points to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetResource implements SdkPojo, Serializable, ToCopyableBuilder<TargetResource.Builder, TargetResource> {
    private static final SdkField<NLBResource> NLB_RESOURCE_FIELD = SdkField.<NLBResource> builder(MarshallingType.SDK_POJO)
            .memberName("NLBResource").getter(getter(TargetResource::nlbResource)).setter(setter(Builder::nlbResource))
            .constructor(NLBResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nLBResource").build()).build();

    private static final SdkField<R53ResourceRecord> R53_RESOURCE_FIELD = SdkField
            .<R53ResourceRecord> builder(MarshallingType.SDK_POJO).memberName("R53Resource")
            .getter(getter(TargetResource::r53Resource)).setter(setter(Builder::r53Resource))
            .constructor(R53ResourceRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("r53Resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NLB_RESOURCE_FIELD,
            R53_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NLBResource nlbResource;

    private final R53ResourceRecord r53Resource;

    private TargetResource(BuilderImpl builder) {
        this.nlbResource = builder.nlbResource;
        this.r53Resource = builder.r53Resource;
    }

    /**
     * <p>
     * The Network Load Balancer Resource.
     * </p>
     * 
     * @return The Network Load Balancer Resource.
     */
    public final NLBResource nlbResource() {
        return nlbResource;
    }

    /**
     * <p>
     * The Route 53 resource.
     * </p>
     * 
     * @return The Route 53 resource.
     */
    public final R53ResourceRecord r53Resource() {
        return r53Resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nlbResource());
        hashCode = 31 * hashCode + Objects.hashCode(r53Resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetResource)) {
            return false;
        }
        TargetResource other = (TargetResource) obj;
        return Objects.equals(nlbResource(), other.nlbResource()) && Objects.equals(r53Resource(), other.r53Resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetResource").add("NLBResource", nlbResource()).add("R53Resource", r53Resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NLBResource":
            return Optional.ofNullable(clazz.cast(nlbResource()));
        case "R53Resource":
            return Optional.ofNullable(clazz.cast(r53Resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nLBResource", NLB_RESOURCE_FIELD);
        map.put("r53Resource", R53_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetResource, T> g) {
        return obj -> g.apply((TargetResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetResource> {
        /**
         * <p>
         * The Network Load Balancer Resource.
         * </p>
         * 
         * @param nlbResource
         *        The Network Load Balancer Resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nlbResource(NLBResource nlbResource);

        /**
         * <p>
         * The Network Load Balancer Resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link NLBResource.Builder} avoiding the need to
         * create one manually via {@link NLBResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NLBResource.Builder#build()} is called immediately and its result
         * is passed to {@link #nlbResource(NLBResource)}.
         * 
         * @param nlbResource
         *        a consumer that will call methods on {@link NLBResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nlbResource(NLBResource)
         */
        default Builder nlbResource(Consumer<NLBResource.Builder> nlbResource) {
            return nlbResource(NLBResource.builder().applyMutation(nlbResource).build());
        }

        /**
         * <p>
         * The Route 53 resource.
         * </p>
         * 
         * @param r53Resource
         *        The Route 53 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder r53Resource(R53ResourceRecord r53Resource);

        /**
         * <p>
         * The Route 53 resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link R53ResourceRecord.Builder} avoiding the
         * need to create one manually via {@link R53ResourceRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link R53ResourceRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #r53Resource(R53ResourceRecord)}.
         * 
         * @param r53Resource
         *        a consumer that will call methods on {@link R53ResourceRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #r53Resource(R53ResourceRecord)
         */
        default Builder r53Resource(Consumer<R53ResourceRecord.Builder> r53Resource) {
            return r53Resource(R53ResourceRecord.builder().applyMutation(r53Resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NLBResource nlbResource;

        private R53ResourceRecord r53Resource;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetResource model) {
            nlbResource(model.nlbResource);
            r53Resource(model.r53Resource);
        }

        public final NLBResource.Builder getNlbResource() {
            return nlbResource != null ? nlbResource.toBuilder() : null;
        }

        public final void setNlbResource(NLBResource.BuilderImpl nlbResource) {
            this.nlbResource = nlbResource != null ? nlbResource.build() : null;
        }

        @Override
        public final Builder nlbResource(NLBResource nlbResource) {
            this.nlbResource = nlbResource;
            return this;
        }

        public final R53ResourceRecord.Builder getR53Resource() {
            return r53Resource != null ? r53Resource.toBuilder() : null;
        }

        public final void setR53Resource(R53ResourceRecord.BuilderImpl r53Resource) {
            this.r53Resource = r53Resource != null ? r53Resource.build() : null;
        }

        @Override
        public final Builder r53Resource(R53ResourceRecord r53Resource) {
            this.r53Resource = r53Resource;
            return this;
        }

        @Override
        public TargetResource build() {
            return new TargetResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
