/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Name of a resource set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceSetRequest extends Route53RecoveryReadinessRequest implements
        ToCopyableBuilder<UpdateResourceSetRequest.Builder, UpdateResourceSetRequest> {
    private static final SdkField<String> RESOURCE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetName").getter(getter(UpdateResourceSetRequest::resourceSetName))
            .setter(setter(Builder::resourceSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceSetName").build()).build();

    private static final SdkField<String> RESOURCE_SET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetType").getter(getter(UpdateResourceSetRequest::resourceSetType))
            .setter(setter(Builder::resourceSetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetType").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(UpdateResourceSetRequest::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_NAME_FIELD,
            RESOURCE_SET_TYPE_FIELD, RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceSetName;

    private final String resourceSetType;

    private final List<Resource> resources;

    private UpdateResourceSetRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSetName = builder.resourceSetName;
        this.resourceSetType = builder.resourceSetType;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * Name of a resource set.
     * </p>
     * 
     * @return Name of a resource set.
     */
    public final String resourceSetName() {
        return resourceSetName;
    }

    /**
     * <p>
     * The resource type of the resources in the resource set. Enter one of the following values for resource type:
     * </p>
     * <p>
     * AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
     * AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer,
     * AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster,
     * AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
     * AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource
     * </p>
     * 
     * @return The resource type of the resources in the resource set. Enter one of the following values for resource
     *         type:</p>
     *         <p>
     *         AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup,
     *         AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
     *         AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer,
     *         AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
     *         AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection,
     *         AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource
     */
    public final String resourceSetType() {
        return resourceSetType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A list of resource objects.
     */
    public final List<Resource> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceSetRequest)) {
            return false;
        }
        UpdateResourceSetRequest other = (UpdateResourceSetRequest) obj;
        return Objects.equals(resourceSetName(), other.resourceSetName())
                && Objects.equals(resourceSetType(), other.resourceSetType()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceSetRequest").add("ResourceSetName", resourceSetName())
                .add("ResourceSetType", resourceSetType()).add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceSetName":
            return Optional.ofNullable(clazz.cast(resourceSetName()));
        case "ResourceSetType":
            return Optional.ofNullable(clazz.cast(resourceSetType()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceSetName", RESOURCE_SET_NAME_FIELD);
        map.put("resourceSetType", RESOURCE_SET_TYPE_FIELD);
        map.put("resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceSetRequest, T> g) {
        return obj -> g.apply((UpdateResourceSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResourceSetRequest> {
        /**
         * <p>
         * Name of a resource set.
         * </p>
         * 
         * @param resourceSetName
         *        Name of a resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetName(String resourceSetName);

        /**
         * <p>
         * The resource type of the resources in the resource set. Enter one of the following values for resource type:
         * </p>
         * <p>
         * AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
         * AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer,
         * AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster,
         * AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
         * AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource
         * </p>
         * 
         * @param resourceSetType
         *        The resource type of the resources in the resource set. Enter one of the following values for resource
         *        type:</p>
         *        <p>
         *        AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup,
         *        AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
         *        AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer,
         *        AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
         *        AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection,
         *        AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetType(String resourceSetType);

        /**
         * <p>
         * A list of resource objects.
         * </p>
         * 
         * @param resources
         *        A list of resource objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * A list of resource objects.
         * </p>
         * 
         * @param resources
         *        A list of resource objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * A list of resource objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.Resource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.Resource.Builder#build()} is called
         * immediately and its result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53recoveryreadiness.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessRequest.BuilderImpl implements Builder {
        private String resourceSetName;

        private String resourceSetType;

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceSetRequest model) {
            super(model);
            resourceSetName(model.resourceSetName);
            resourceSetType(model.resourceSetType);
            resources(model.resources);
        }

        public final String getResourceSetName() {
            return resourceSetName;
        }

        public final void setResourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
        }

        @Override
        public final Builder resourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        public final String getResourceSetType() {
            return resourceSetType;
        }

        public final void setResourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
        }

        @Override
        public final Builder resourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ___listOfResourceCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ___listOfResourceCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ___listOfResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceSetRequest build() {
            return new UpdateResourceSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
