/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RecoveryGroupOutput;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfRecoveryGroupOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecoveryGroupsResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, ListRecoveryGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecoveryGroupsResponse.getter(ListRecoveryGroupsResponse::nextToken)).setter(ListRecoveryGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RecoveryGroupOutput>> RECOVERY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecoveryGroups").getter(ListRecoveryGroupsResponse.getter(ListRecoveryGroupsResponse::recoveryGroups)).setter(ListRecoveryGroupsResponse.setter(Builder::recoveryGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryGroupOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOVERY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecoveryGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecoveryGroupOutput> recoveryGroups;

    private ListRecoveryGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recoveryGroups = builder.recoveryGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecoveryGroups() {
        return this.recoveryGroups != null && !(this.recoveryGroups instanceof SdkAutoConstructList);
    }

    public final List<RecoveryGroupOutput> recoveryGroups() {
        return this.recoveryGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryGroups() ? this.recoveryGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryGroupsResponse)) {
            return false;
        }
        ListRecoveryGroupsResponse other = (ListRecoveryGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecoveryGroups() == other.hasRecoveryGroups() && Objects.equals(this.recoveryGroups(), other.recoveryGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecoveryGroupsResponse").add("NextToken", (Object)this.nextToken()).add("RecoveryGroups", this.hasRecoveryGroups() ? this.recoveryGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RecoveryGroups": {
                return Optional.ofNullable(clazz.cast(this.recoveryGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("recoveryGroups", RECOVERY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryGroupsResponse, T> g) {
        return obj -> g.apply((ListRecoveryGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecoveryGroupOutput> recoveryGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recoveryGroups(model.recoveryGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecoveryGroupOutput.Builder> getRecoveryGroups() {
            List<RecoveryGroupOutput.Builder> result = ___listOfRecoveryGroupOutputCopier.copyToBuilder(this.recoveryGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecoveryGroups(Collection<RecoveryGroupOutput.BuilderImpl> recoveryGroups) {
            this.recoveryGroups = ___listOfRecoveryGroupOutputCopier.copyFromBuilder(recoveryGroups);
        }

        @Override
        public final Builder recoveryGroups(Collection<RecoveryGroupOutput> recoveryGroups) {
            this.recoveryGroups = ___listOfRecoveryGroupOutputCopier.copy(recoveryGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryGroups(RecoveryGroupOutput ... recoveryGroups) {
            this.recoveryGroups(Arrays.asList(recoveryGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryGroups(Consumer<RecoveryGroupOutput.Builder> ... recoveryGroups) {
            this.recoveryGroups(Stream.of(recoveryGroups).map(c -> (RecoveryGroupOutput)((RecoveryGroupOutput.Builder)RecoveryGroupOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecoveryGroupsResponse build() {
            return new ListRecoveryGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecoveryGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder recoveryGroups(Collection<RecoveryGroupOutput> var1);

        public Builder recoveryGroups(RecoveryGroupOutput ... var1);

        public Builder recoveryGroups(Consumer<RecoveryGroupOutput.Builder> ... var1);
    }
}

