/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReadinessCheckRequest
extends Route53RecoveryReadinessRequest
implements ToCopyableBuilder<Builder, UpdateReadinessCheckRequest> {
    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckName").getter(UpdateReadinessCheckRequest.getter(UpdateReadinessCheckRequest::readinessCheckName)).setter(UpdateReadinessCheckRequest.setter(Builder::readinessCheckName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("readinessCheckName").build()}).build();
    private static final SdkField<String> RESOURCE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetName").getter(UpdateReadinessCheckRequest.getter(UpdateReadinessCheckRequest::resourceSetName)).setter(UpdateReadinessCheckRequest.setter(Builder::resourceSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_CHECK_NAME_FIELD, RESOURCE_SET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReadinessCheckRequest.memberNameToFieldInitializer();
    private final String readinessCheckName;
    private final String resourceSetName;

    private UpdateReadinessCheckRequest(BuilderImpl builder) {
        super(builder);
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceSetName = builder.resourceSetName;
    }

    public final String readinessCheckName() {
        return this.readinessCheckName;
    }

    public final String resourceSetName() {
        return this.resourceSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReadinessCheckRequest)) {
            return false;
        }
        UpdateReadinessCheckRequest other = (UpdateReadinessCheckRequest)((Object)obj);
        return Objects.equals(this.readinessCheckName(), other.readinessCheckName()) && Objects.equals(this.resourceSetName(), other.resourceSetName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReadinessCheckRequest").add("ReadinessCheckName", (Object)this.readinessCheckName()).add("ResourceSetName", (Object)this.resourceSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadinessCheckName": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckName()));
            }
            case "ResourceSetName": {
                return Optional.ofNullable(clazz.cast(this.resourceSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("readinessCheckName", READINESS_CHECK_NAME_FIELD);
        map.put("resourceSetName", RESOURCE_SET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReadinessCheckRequest, T> g) {
        return obj -> g.apply((UpdateReadinessCheckRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessRequest.BuilderImpl
    implements Builder {
        private String readinessCheckName;
        private String resourceSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReadinessCheckRequest model) {
            super(model);
            this.readinessCheckName(model.readinessCheckName);
            this.resourceSetName(model.resourceSetName);
        }

        public final String getReadinessCheckName() {
            return this.readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final String getResourceSetName() {
            return this.resourceSetName;
        }

        public final void setResourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
        }

        @Override
        public final Builder resourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReadinessCheckRequest build() {
            return new UpdateReadinessCheckRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53RecoveryReadinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReadinessCheckRequest> {
        public Builder readinessCheckName(String var1);

        public Builder resourceSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

