/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A component for DNS/routing control readiness checks and architecture checks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DNSTargetResource implements SdkPojo, Serializable,
        ToCopyableBuilder<DNSTargetResource.Builder, DNSTargetResource> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DNSTargetResource::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneArn").getter(getter(DNSTargetResource::hostedZoneArn)).setter(setter(Builder::hostedZoneArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneArn").build()).build();

    private static final SdkField<String> RECORD_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordSetId").getter(getter(DNSTargetResource::recordSetId)).setter(setter(Builder::recordSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetId").build()).build();

    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordType").getter(getter(DNSTargetResource::recordType)).setter(setter(Builder::recordType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordType").build()).build();

    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField
            .<TargetResource> builder(MarshallingType.SDK_POJO).memberName("TargetResource")
            .getter(getter(DNSTargetResource::targetResource)).setter(setter(Builder::targetResource))
            .constructor(TargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            HOSTED_ZONE_ARN_FIELD, RECORD_SET_ID_FIELD, RECORD_TYPE_FIELD, TARGET_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String hostedZoneArn;

    private final String recordSetId;

    private final String recordType;

    private final TargetResource targetResource;

    private DNSTargetResource(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.hostedZoneArn = builder.hostedZoneArn;
        this.recordSetId = builder.recordSetId;
        this.recordType = builder.recordType;
        this.targetResource = builder.targetResource;
    }

    /**
     * <p>
     * The domain name that acts as an ingress point to a portion of the customer application.
     * </p>
     * 
     * @return The domain name that acts as an ingress point to a portion of the customer application.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target
     * resource.
     * </p>
     * 
     * @return The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the
     *         target resource.
     */
    public final String hostedZoneArn() {
        return hostedZoneArn;
    }

    /**
     * <p>
     * The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
     * </p>
     * 
     * @return The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
     */
    public final String recordSetId() {
        return recordSetId;
    }

    /**
     * <p>
     * The type of DNS record of the target resource.
     * </p>
     * 
     * @return The type of DNS record of the target resource.
     */
    public final String recordType() {
        return recordType;
    }

    /**
     * <p>
     * The target resource of the DNS target resource.
     * </p>
     * 
     * @return The target resource of the DNS target resource.
     */
    public final TargetResource targetResource() {
        return targetResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneArn());
        hashCode = 31 * hashCode + Objects.hashCode(recordSetId());
        hashCode = 31 * hashCode + Objects.hashCode(recordType());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNSTargetResource)) {
            return false;
        }
        DNSTargetResource other = (DNSTargetResource) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(hostedZoneArn(), other.hostedZoneArn())
                && Objects.equals(recordSetId(), other.recordSetId()) && Objects.equals(recordType(), other.recordType())
                && Objects.equals(targetResource(), other.targetResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DNSTargetResource").add("DomainName", domainName()).add("HostedZoneArn", hostedZoneArn())
                .add("RecordSetId", recordSetId()).add("RecordType", recordType()).add("TargetResource", targetResource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "HostedZoneArn":
            return Optional.ofNullable(clazz.cast(hostedZoneArn()));
        case "RecordSetId":
            return Optional.ofNullable(clazz.cast(recordSetId()));
        case "RecordType":
            return Optional.ofNullable(clazz.cast(recordType()));
        case "TargetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("hostedZoneArn", HOSTED_ZONE_ARN_FIELD);
        map.put("recordSetId", RECORD_SET_ID_FIELD);
        map.put("recordType", RECORD_TYPE_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DNSTargetResource, T> g) {
        return obj -> g.apply((DNSTargetResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DNSTargetResource> {
        /**
         * <p>
         * The domain name that acts as an ingress point to a portion of the customer application.
         * </p>
         * 
         * @param domainName
         *        The domain name that acts as an ingress point to a portion of the customer application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target
         * resource.
         * </p>
         * 
         * @param hostedZoneArn
         *        The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the
         *        target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneArn(String hostedZoneArn);

        /**
         * <p>
         * The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
         * </p>
         * 
         * @param recordSetId
         *        The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSetId(String recordSetId);

        /**
         * <p>
         * The type of DNS record of the target resource.
         * </p>
         * 
         * @param recordType
         *        The type of DNS record of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The target resource of the DNS target resource.
         * </p>
         * 
         * @param targetResource
         *        The target resource of the DNS target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(TargetResource targetResource);

        /**
         * <p>
         * The target resource of the DNS target resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetResource.Builder} avoiding the need
         * to create one manually via {@link TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResource(TargetResource)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(TargetResource)
         */
        default Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return targetResource(TargetResource.builder().applyMutation(targetResource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String hostedZoneArn;

        private String recordSetId;

        private String recordType;

        private TargetResource targetResource;

        private BuilderImpl() {
        }

        private BuilderImpl(DNSTargetResource model) {
            domainName(model.domainName);
            hostedZoneArn(model.hostedZoneArn);
            recordSetId(model.recordSetId);
            recordType(model.recordType);
            targetResource(model.targetResource);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getHostedZoneArn() {
            return hostedZoneArn;
        }

        public final void setHostedZoneArn(String hostedZoneArn) {
            this.hostedZoneArn = hostedZoneArn;
        }

        @Override
        public final Builder hostedZoneArn(String hostedZoneArn) {
            this.hostedZoneArn = hostedZoneArn;
            return this;
        }

        public final String getRecordSetId() {
            return recordSetId;
        }

        public final void setRecordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
        }

        @Override
        public final Builder recordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
            return this;
        }

        public final String getRecordType() {
            return recordType;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        @Override
        public DNSTargetResource build() {
            return new DNSTargetResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
