/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A readiness check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadinessCheckOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadinessCheckOutput.Builder, ReadinessCheckOutput> {
    private static final SdkField<String> READINESS_CHECK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadinessCheckArn").getter(getter(ReadinessCheckOutput::readinessCheckArn))
            .setter(setter(Builder::readinessCheckArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckArn").build()).build();

    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadinessCheckName").getter(getter(ReadinessCheckOutput::readinessCheckName))
            .setter(setter(Builder::readinessCheckName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckName").build())
            .build();

    private static final SdkField<String> RESOURCE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSet").getter(getter(ReadinessCheckOutput::resourceSet)).setter(setter(Builder::resourceSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSet").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ReadinessCheckOutput::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_CHECK_ARN_FIELD,
            READINESS_CHECK_NAME_FIELD, RESOURCE_SET_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String readinessCheckArn;

    private final String readinessCheckName;

    private final String resourceSet;

    private final Map<String, String> tags;

    private ReadinessCheckOutput(BuilderImpl builder) {
        this.readinessCheckArn = builder.readinessCheckArn;
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceSet = builder.resourceSet;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with a readiness check.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with a readiness check.
     */
    public final String readinessCheckArn() {
        return readinessCheckArn;
    }

    /**
     * <p>
     * Name of a readiness check.
     * </p>
     * 
     * @return Name of a readiness check.
     */
    public final String readinessCheckName() {
        return readinessCheckName;
    }

    /**
     * <p>
     * Name of the resource set to be checked.
     * </p>
     * 
     * @return Name of the resource set to be checked.
     */
    public final String resourceSet() {
        return resourceSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readinessCheckArn());
        hashCode = 31 * hashCode + Objects.hashCode(readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSet());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadinessCheckOutput)) {
            return false;
        }
        ReadinessCheckOutput other = (ReadinessCheckOutput) obj;
        return Objects.equals(readinessCheckArn(), other.readinessCheckArn())
                && Objects.equals(readinessCheckName(), other.readinessCheckName())
                && Objects.equals(resourceSet(), other.resourceSet()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadinessCheckOutput").add("ReadinessCheckArn", readinessCheckArn())
                .add("ReadinessCheckName", readinessCheckName()).add("ResourceSet", resourceSet())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadinessCheckArn":
            return Optional.ofNullable(clazz.cast(readinessCheckArn()));
        case "ReadinessCheckName":
            return Optional.ofNullable(clazz.cast(readinessCheckName()));
        case "ResourceSet":
            return Optional.ofNullable(clazz.cast(resourceSet()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("readinessCheckArn", READINESS_CHECK_ARN_FIELD);
        map.put("readinessCheckName", READINESS_CHECK_NAME_FIELD);
        map.put("resourceSet", RESOURCE_SET_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadinessCheckOutput, T> g) {
        return obj -> g.apply((ReadinessCheckOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadinessCheckOutput> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with a readiness check.
         * </p>
         * 
         * @param readinessCheckArn
         *        The Amazon Resource Name (ARN) associated with a readiness check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessCheckArn(String readinessCheckArn);

        /**
         * <p>
         * Name of a readiness check.
         * </p>
         * 
         * @param readinessCheckName
         *        Name of a readiness check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessCheckName(String readinessCheckName);

        /**
         * <p>
         * Name of the resource set to be checked.
         * </p>
         * 
         * @param resourceSet
         *        Name of the resource set to be checked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSet(String resourceSet);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String readinessCheckArn;

        private String readinessCheckName;

        private String resourceSet;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReadinessCheckOutput model) {
            readinessCheckArn(model.readinessCheckArn);
            readinessCheckName(model.readinessCheckName);
            resourceSet(model.resourceSet);
            tags(model.tags);
        }

        public final String getReadinessCheckArn() {
            return readinessCheckArn;
        }

        public final void setReadinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
        }

        @Override
        public final Builder readinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
            return this;
        }

        public final String getReadinessCheckName() {
            return readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final String getResourceSet() {
            return resourceSet;
        }

        public final void setResourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
        }

        @Override
        public final Builder resourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public ReadinessCheckOutput build() {
            return new ReadinessCheckOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
