/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Name of a recovery group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecoveryGroupRequest extends Route53RecoveryReadinessRequest implements
        ToCopyableBuilder<UpdateRecoveryGroupRequest.Builder, UpdateRecoveryGroupRequest> {
    private static final SdkField<List<String>> CELLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cells")
            .getter(getter(UpdateRecoveryGroupRequest::cells))
            .setter(setter(Builder::cells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOVERY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryGroupName").getter(getter(UpdateRecoveryGroupRequest::recoveryGroupName))
            .setter(setter(Builder::recoveryGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("recoveryGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD,
            RECOVERY_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> cells;

    private final String recoveryGroupName;

    private UpdateRecoveryGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cells = builder.cells;
        this.recoveryGroupName = builder.recoveryGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cells property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCells() {
        return cells != null && !(cells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCells} method.
     * </p>
     * 
     * @return A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
     */
    public final List<String> cells() {
        return cells;
    }

    /**
     * <p>
     * The name of a recovery group.
     * </p>
     * 
     * @return The name of a recovery group.
     */
    public final String recoveryGroupName() {
        return recoveryGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCells() ? cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recoveryGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryGroupRequest)) {
            return false;
        }
        UpdateRecoveryGroupRequest other = (UpdateRecoveryGroupRequest) obj;
        return hasCells() == other.hasCells() && Objects.equals(cells(), other.cells())
                && Objects.equals(recoveryGroupName(), other.recoveryGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecoveryGroupRequest").add("Cells", hasCells() ? cells() : null)
                .add("RecoveryGroupName", recoveryGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cells":
            return Optional.ofNullable(clazz.cast(cells()));
        case "RecoveryGroupName":
            return Optional.ofNullable(clazz.cast(recoveryGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cells", CELLS_FIELD);
        map.put("recoveryGroupName", RECOVERY_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryGroupRequest, T> g) {
        return obj -> g.apply((UpdateRecoveryGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53RecoveryReadinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecoveryGroupRequest> {
        /**
         * <p>
         * A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
         * </p>
         * 
         * @param cells
         *        A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Collection<String> cells);

        /**
         * <p>
         * A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
         * </p>
         * 
         * @param cells
         *        A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(String... cells);

        /**
         * <p>
         * The name of a recovery group.
         * </p>
         * 
         * @param recoveryGroupName
         *        The name of a recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryGroupName(String recoveryGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessRequest.BuilderImpl implements Builder {
        private List<String> cells = DefaultSdkAutoConstructList.getInstance();

        private String recoveryGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryGroupRequest model) {
            super(model);
            cells(model.cells);
            recoveryGroupName(model.recoveryGroupName);
        }

        public final Collection<String> getCells() {
            if (cells instanceof SdkAutoConstructList) {
                return null;
            }
            return cells;
        }

        public final void setCells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
        }

        @Override
        public final Builder cells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(String... cells) {
            cells(Arrays.asList(cells));
            return this;
        }

        public final String getRecoveryGroupName() {
            return recoveryGroupName;
        }

        public final void setRecoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
        }

        @Override
        public final Builder recoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecoveryGroupRequest build() {
            return new UpdateRecoveryGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
