/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfReadinessCheckSummaryCopier {
    static List<ReadinessCheckSummary> copy(Collection<? extends ReadinessCheckSummary> __listOfReadinessCheckSummaryParam) {
        List<ReadinessCheckSummary> list;
        if (__listOfReadinessCheckSummaryParam == null || __listOfReadinessCheckSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReadinessCheckSummary> modifiableList = new ArrayList<>(__listOfReadinessCheckSummaryParam.size());
            __listOfReadinessCheckSummaryParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReadinessCheckSummary> copyFromBuilder(
            Collection<? extends ReadinessCheckSummary.Builder> __listOfReadinessCheckSummaryParam) {
        List<ReadinessCheckSummary> list;
        if (__listOfReadinessCheckSummaryParam == null || __listOfReadinessCheckSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReadinessCheckSummary> modifiableList = new ArrayList<>(__listOfReadinessCheckSummaryParam.size());
            __listOfReadinessCheckSummaryParam.forEach(entry -> {
                ReadinessCheckSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReadinessCheckSummary.Builder> copyToBuilder(
            Collection<? extends ReadinessCheckSummary> __listOfReadinessCheckSummaryParam) {
        List<ReadinessCheckSummary.Builder> list;
        if (__listOfReadinessCheckSummaryParam == null || __listOfReadinessCheckSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReadinessCheckSummary.Builder> modifiableList = new ArrayList<>(__listOfReadinessCheckSummaryParam.size());
            __listOfReadinessCheckSummaryParam.forEach(entry -> {
                ReadinessCheckSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
