/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfRuleResultCopier {
    static List<RuleResult> copy(Collection<? extends RuleResult> __listOfRuleResultParam) {
        List<RuleResult> list;
        if (__listOfRuleResultParam == null || __listOfRuleResultParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RuleResult> modifiableList = new ArrayList<>(__listOfRuleResultParam.size());
            __listOfRuleResultParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RuleResult> copyFromBuilder(Collection<? extends RuleResult.Builder> __listOfRuleResultParam) {
        List<RuleResult> list;
        if (__listOfRuleResultParam == null || __listOfRuleResultParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RuleResult> modifiableList = new ArrayList<>(__listOfRuleResultParam.size());
            __listOfRuleResultParam.forEach(entry -> {
                RuleResult member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RuleResult.Builder> copyToBuilder(Collection<? extends RuleResult> __listOfRuleResultParam) {
        List<RuleResult.Builder> list;
        if (__listOfRuleResultParam == null || __listOfRuleResultParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RuleResult.Builder> modifiableList = new ArrayList<>(__listOfRuleResultParam.size());
            __listOfRuleResultParam.forEach(entry -> {
                RuleResult.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
