/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallDomainListResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<DeleteFirewallDomainListResponse.Builder, DeleteFirewallDomainListResponse> {
    private static final SdkField<FirewallDomainList> FIREWALL_DOMAIN_LIST_FIELD = SdkField
            .<FirewallDomainList> builder(MarshallingType.SDK_POJO).memberName("FirewallDomainList")
            .getter(getter(DeleteFirewallDomainListResponse::firewallDomainList)).setter(setter(Builder::firewallDomainList))
            .constructor(FirewallDomainList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainList").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_DOMAIN_LIST_FIELD));

    private final FirewallDomainList firewallDomainList;

    private DeleteFirewallDomainListResponse(BuilderImpl builder) {
        super(builder);
        this.firewallDomainList = builder.firewallDomainList;
    }

    /**
     * <p>
     * The domain list that you just deleted.
     * </p>
     * 
     * @return The domain list that you just deleted.
     */
    public final FirewallDomainList firewallDomainList() {
        return firewallDomainList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallDomainListResponse)) {
            return false;
        }
        DeleteFirewallDomainListResponse other = (DeleteFirewallDomainListResponse) obj;
        return Objects.equals(firewallDomainList(), other.firewallDomainList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallDomainListResponse").add("FirewallDomainList", firewallDomainList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallDomainList":
            return Optional.ofNullable(clazz.cast(firewallDomainList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallDomainListResponse, T> g) {
        return obj -> g.apply((DeleteFirewallDomainListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFirewallDomainListResponse> {
        /**
         * <p>
         * The domain list that you just deleted.
         * </p>
         * 
         * @param firewallDomainList
         *        The domain list that you just deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainList(FirewallDomainList firewallDomainList);

        /**
         * <p>
         * The domain list that you just deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallDomainList.Builder} avoiding the need to
         * create one manually via {@link FirewallDomainList#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallDomainList.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallDomainList(FirewallDomainList)}.
         * 
         * @param firewallDomainList
         *        a consumer that will call methods on {@link FirewallDomainList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallDomainList(FirewallDomainList)
         */
        default Builder firewallDomainList(Consumer<FirewallDomainList.Builder> firewallDomainList) {
            return firewallDomainList(FirewallDomainList.builder().applyMutation(firewallDomainList).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private FirewallDomainList firewallDomainList;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallDomainListResponse model) {
            super(model);
            firewallDomainList(model.firewallDomainList);
        }

        public final FirewallDomainList.Builder getFirewallDomainList() {
            return firewallDomainList != null ? firewallDomainList.toBuilder() : null;
        }

        @Override
        public final Builder firewallDomainList(FirewallDomainList firewallDomainList) {
            this.firewallDomainList = firewallDomainList;
            return this;
        }

        public final void setFirewallDomainList(FirewallDomainList.BuilderImpl firewallDomainList) {
            this.firewallDomainList = firewallDomainList != null ? firewallDomainList.build() : null;
        }

        @Override
        public DeleteFirewallDomainListResponse build() {
            return new DeleteFirewallDomainListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
