/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Minimal high-level information for a firewall domain list. The action <a>ListFirewallDomainLists</a> returns an array
 * of these objects.
 * </p>
 * <p>
 * To retrieve full information for a firewall domain list, call <a>GetFirewallDomainList</a> and
 * <a>ListFirewallDomains</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallDomainListMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallDomainListMetadata.Builder, FirewallDomainListMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallDomainListMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FirewallDomainListMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallDomainListMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallDomainListMetadata::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> MANAGED_OWNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedOwnerName").getter(getter(FirewallDomainListMetadata::managedOwnerName))
            .setter(setter(Builder::managedOwnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedOwnerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CREATOR_REQUEST_ID_FIELD, MANAGED_OWNER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String creatorRequestId;

    private final String managedOwnerName;

    private FirewallDomainListMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.managedOwnerName = builder.managedOwnerName;
    }

    /**
     * <p>
     * The ID of the domain list.
     * </p>
     * 
     * @return The ID of the domain list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall domain list metadata.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall domain list metadata.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the domain list.
     * </p>
     * 
     * @return The name of the domain list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of executing the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list
     * <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
     * <code>Route 53 Resolver DNS Firewall</code>.
     * </p>
     * 
     * @return The owner of the list, used only for lists that are not managed by you. For example, the managed domain
     *         list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
     *         <code>Route 53 Resolver DNS Firewall</code>.
     */
    public final String managedOwnerName() {
        return managedOwnerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(managedOwnerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallDomainListMetadata)) {
            return false;
        }
        FirewallDomainListMetadata other = (FirewallDomainListMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(managedOwnerName(), other.managedOwnerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallDomainListMetadata").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("CreatorRequestId", creatorRequestId()).add("ManagedOwnerName", managedOwnerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "ManagedOwnerName":
            return Optional.ofNullable(clazz.cast(managedOwnerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallDomainListMetadata, T> g) {
        return obj -> g.apply((FirewallDomainListMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallDomainListMetadata> {
        /**
         * <p>
         * The ID of the domain list.
         * </p>
         * 
         * @param id
         *        The ID of the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall domain list metadata.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the firewall domain list metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the domain list.
         * </p>
         * 
         * @param name
         *        The name of the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of executing the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of executing the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list
         * <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
         * <code>Route 53 Resolver DNS Firewall</code>.
         * </p>
         * 
         * @param managedOwnerName
         *        The owner of the list, used only for lists that are not managed by you. For example, the managed
         *        domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
         *        <code>Route 53 Resolver DNS Firewall</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedOwnerName(String managedOwnerName);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String creatorRequestId;

        private String managedOwnerName;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallDomainListMetadata model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            creatorRequestId(model.creatorRequestId);
            managedOwnerName(model.managedOwnerName);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getManagedOwnerName() {
            return managedOwnerName;
        }

        @Override
        public final Builder managedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
            return this;
        }

        public final void setManagedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
        }

        @Override
        public FirewallDomainListMetadata build() {
            return new FirewallDomainListMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
