/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallRuleResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<DeleteFirewallRuleResponse.Builder, DeleteFirewallRuleResponse> {
    private static final SdkField<FirewallRule> FIREWALL_RULE_FIELD = SdkField.<FirewallRule> builder(MarshallingType.SDK_POJO)
            .memberName("FirewallRule").getter(getter(DeleteFirewallRuleResponse::firewallRule))
            .setter(setter(Builder::firewallRule)).constructor(FirewallRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_FIELD));

    private final FirewallRule firewallRule;

    private DeleteFirewallRuleResponse(BuilderImpl builder) {
        super(builder);
        this.firewallRule = builder.firewallRule;
    }

    /**
     * <p>
     * The specification for the firewall rule that you just deleted.
     * </p>
     * 
     * @return The specification for the firewall rule that you just deleted.
     */
    public final FirewallRule firewallRule() {
        return firewallRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallRuleResponse)) {
            return false;
        }
        DeleteFirewallRuleResponse other = (DeleteFirewallRuleResponse) obj;
        return Objects.equals(firewallRule(), other.firewallRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallRuleResponse").add("FirewallRule", firewallRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRule":
            return Optional.ofNullable(clazz.cast(firewallRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallRuleResponse, T> g) {
        return obj -> g.apply((DeleteFirewallRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFirewallRuleResponse> {
        /**
         * <p>
         * The specification for the firewall rule that you just deleted.
         * </p>
         * 
         * @param firewallRule
         *        The specification for the firewall rule that you just deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRule(FirewallRule firewallRule);

        /**
         * <p>
         * The specification for the firewall rule that you just deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallRule.Builder} avoiding the need to
         * create one manually via {@link FirewallRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallRule.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallRule(FirewallRule)}.
         * 
         * @param firewallRule
         *        a consumer that will call methods on {@link FirewallRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRule(FirewallRule)
         */
        default Builder firewallRule(Consumer<FirewallRule.Builder> firewallRule) {
            return firewallRule(FirewallRule.builder().applyMutation(firewallRule).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private FirewallRule firewallRule;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallRuleResponse model) {
            super(model);
            firewallRule(model.firewallRule);
        }

        public final FirewallRule.Builder getFirewallRule() {
            return firewallRule != null ? firewallRule.toBuilder() : null;
        }

        @Override
        public final Builder firewallRule(FirewallRule firewallRule) {
            this.firewallRule = firewallRule;
            return this;
        }

        public final void setFirewallRule(FirewallRule.BuilderImpl firewallRule) {
            this.firewallRule = firewallRule != null ? firewallRule.build() : null;
        }

        @Override
        public DeleteFirewallRuleResponse build() {
            return new DeleteFirewallRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
