/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Minimal high-level information for a firewall rule group. The action <a>ListFirewallRuleGroups</a> returns an array
 * of these objects.
 * </p>
 * <p>
 * To retrieve full information for a firewall rule group, call <a>GetFirewallRuleGroup</a> and
 * <a>ListFirewallRules</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallRuleGroupMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallRuleGroupMetadata.Builder, FirewallRuleGroupMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallRuleGroupMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FirewallRuleGroupMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallRuleGroupMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(FirewallRuleGroupMetadata::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallRuleGroupMetadata::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(FirewallRuleGroupMetadata::shareStatusAsString))
            .setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, OWNER_ID_FIELD, CREATOR_REQUEST_ID_FIELD, SHARE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String ownerId;

    private final String creatorRequestId;

    private final String shareStatus;

    private FirewallRuleGroupMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.creatorRequestId = builder.creatorRequestId;
        this.shareStatus = builder.shareStatus;
    }

    /**
     * <p>
     * The ID of the rule group.
     * </p>
     * 
     * @return The ID of the rule group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the rule group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the rule group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the rule group.
     * </p>
     * 
     * @return The name of the rule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The AWS account ID for the account that created the rule group. When a rule group is shared with your account,
     * this is the account that has shared the rule group with you.
     * </p>
     * 
     * @return The AWS account ID for the account that created the rule group. When a rule group is shared with your
     *         account, this is the account that has shared the rule group with you.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of running the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS
     * account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Whether the rule group is shared with other AWS accounts, or was shared with the current account by
     *         another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS
     * account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Whether the rule group is shared with other AWS accounts, or was shared with the current account by
     *         another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroupMetadata)) {
            return false;
        }
        FirewallRuleGroupMetadata other = (FirewallRuleGroupMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallRuleGroupMetadata").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("OwnerId", ownerId()).add("CreatorRequestId", creatorRequestId()).add("ShareStatus", shareStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroupMetadata, T> g) {
        return obj -> g.apply((FirewallRuleGroupMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallRuleGroupMetadata> {
        /**
         * <p>
         * The ID of the rule group.
         * </p>
         * 
         * @param id
         *        The ID of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the rule group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the rule group.
         * </p>
         * 
         * @param name
         *        The name of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS account ID for the account that created the rule group. When a rule group is shared with your
         * account, this is the account that has shared the rule group with you.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID for the account that created the rule group. When a rule group is shared with your
         *        account, this is the account that has shared the rule group with you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of running the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of running the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another
         * AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * </p>
         * 
         * @param shareStatus
         *        Whether the rule group is shared with other AWS accounts, or was shared with the current account by
         *        another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another
         * AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * </p>
         * 
         * @param shareStatus
         *        Whether the rule group is shared with other AWS accounts, or was shared with the current account by
         *        another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String ownerId;

        private String creatorRequestId;

        private String shareStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroupMetadata model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            ownerId(model.ownerId);
            creatorRequestId(model.creatorRequestId);
            shareStatus(model.shareStatus);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public FirewallRuleGroupMetadata build() {
            return new FirewallRuleGroupMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
