/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFirewallConfigResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetFirewallConfigResponse.Builder, GetFirewallConfigResponse> {
    private static final SdkField<FirewallConfig> FIREWALL_CONFIG_FIELD = SdkField
            .<FirewallConfig> builder(MarshallingType.SDK_POJO).memberName("FirewallConfig")
            .getter(getter(GetFirewallConfigResponse::firewallConfig)).setter(setter(Builder::firewallConfig))
            .constructor(FirewallConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_CONFIG_FIELD));

    private final FirewallConfig firewallConfig;

    private GetFirewallConfigResponse(BuilderImpl builder) {
        super(builder);
        this.firewallConfig = builder.firewallConfig;
    }

    /**
     * <p>
     * Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC.
     * </p>
     * 
     * @return Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC.
     */
    public final FirewallConfig firewallConfig() {
        return firewallConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFirewallConfigResponse)) {
            return false;
        }
        GetFirewallConfigResponse other = (GetFirewallConfigResponse) obj;
        return Objects.equals(firewallConfig(), other.firewallConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFirewallConfigResponse").add("FirewallConfig", firewallConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallConfig":
            return Optional.ofNullable(clazz.cast(firewallConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFirewallConfigResponse, T> g) {
        return obj -> g.apply((GetFirewallConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFirewallConfigResponse> {
        /**
         * <p>
         * Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC.
         * </p>
         * 
         * @param firewallConfig
         *        Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallConfig(FirewallConfig firewallConfig);

        /**
         * <p>
         * Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallConfig.Builder} avoiding the need to
         * create one manually via {@link FirewallConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #firewallConfig(FirewallConfig)}.
         * 
         * @param firewallConfig
         *        a consumer that will call methods on {@link FirewallConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallConfig(FirewallConfig)
         */
        default Builder firewallConfig(Consumer<FirewallConfig.Builder> firewallConfig) {
            return firewallConfig(FirewallConfig.builder().applyMutation(firewallConfig).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private FirewallConfig firewallConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFirewallConfigResponse model) {
            super(model);
            firewallConfig(model.firewallConfig);
        }

        public final FirewallConfig.Builder getFirewallConfig() {
            return firewallConfig != null ? firewallConfig.toBuilder() : null;
        }

        @Override
        public final Builder firewallConfig(FirewallConfig firewallConfig) {
            this.firewallConfig = firewallConfig;
            return this;
        }

        public final void setFirewallConfig(FirewallConfig.BuilderImpl firewallConfig) {
            this.firewallConfig = firewallConfig != null ? firewallConfig.build() : null;
        }

        @Override
        public GetFirewallConfigResponse build() {
            return new GetFirewallConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
