/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResolverRulePolicyRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<PutResolverRulePolicyRequest.Builder, PutResolverRulePolicyRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PutResolverRulePolicyRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> RESOLVER_RULE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverRulePolicy").getter(getter(PutResolverRulePolicyRequest::resolverRulePolicy))
            .setter(setter(Builder::resolverRulePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRulePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            RESOLVER_RULE_POLICY_FIELD));

    private final String arn;

    private final String resolverRulePolicy;

    private PutResolverRulePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.resolverRulePolicy = builder.resolverRulePolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule that you want to share with another account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule that you want to share with another account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An AWS Identity and Access Management policy statement that lists the rules that you want to share with another
     * AWS account and the operations that you want the account to be able to perform. You can specify the following
     * operations in the <code>Action</code> section of the statement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>route53resolver:GetResolverRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:AssociateResolverRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:DisassociateResolverRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:ListResolverRules</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:ListResolverRuleAssociations</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with
     * another account. Specify the same ARN that you specified in <code>Arn</code>.
     * </p>
     * 
     * @return An AWS Identity and Access Management policy statement that lists the rules that you want to share with
     *         another AWS account and the operations that you want the account to be able to perform. You can specify
     *         the following operations in the <code>Action</code> section of the statement:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>route53resolver:GetResolverRule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:AssociateResolverRule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:DisassociateResolverRule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:ListResolverRules</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:ListResolverRuleAssociations</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to
     *         share with another account. Specify the same ARN that you specified in <code>Arn</code>.
     */
    public final String resolverRulePolicy() {
        return resolverRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resolverRulePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResolverRulePolicyRequest)) {
            return false;
        }
        PutResolverRulePolicyRequest other = (PutResolverRulePolicyRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(resolverRulePolicy(), other.resolverRulePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResolverRulePolicyRequest").add("Arn", arn()).add("ResolverRulePolicy", resolverRulePolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ResolverRulePolicy":
            return Optional.ofNullable(clazz.cast(resolverRulePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResolverRulePolicyRequest, T> g) {
        return obj -> g.apply((PutResolverRulePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutResolverRulePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule that you want to share with another account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the rule that you want to share with another account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An AWS Identity and Access Management policy statement that lists the rules that you want to share with
         * another AWS account and the operations that you want the account to be able to perform. You can specify the
         * following operations in the <code>Action</code> section of the statement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>route53resolver:GetResolverRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:AssociateResolverRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:DisassociateResolverRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:ListResolverRules</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:ListResolverRuleAssociations</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share
         * with another account. Specify the same ARN that you specified in <code>Arn</code>.
         * </p>
         * 
         * @param resolverRulePolicy
         *        An AWS Identity and Access Management policy statement that lists the rules that you want to share
         *        with another AWS account and the operations that you want the account to be able to perform. You can
         *        specify the following operations in the <code>Action</code> section of the statement:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>route53resolver:GetResolverRule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:AssociateResolverRule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:DisassociateResolverRule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:ListResolverRules</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:ListResolverRuleAssociations</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to
         *        share with another account. Specify the same ARN that you specified in <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRulePolicy(String resolverRulePolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String arn;

        private String resolverRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResolverRulePolicyRequest model) {
            super(model);
            arn(model.arn);
            resolverRulePolicy(model.resolverRulePolicy);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResolverRulePolicy() {
            return resolverRulePolicy;
        }

        @Override
        public final Builder resolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
            return this;
        }

        public final void setResolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResolverRulePolicyRequest build() {
            return new PutResolverRulePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
