/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFirewallRuleGroupRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<AssociateFirewallRuleGroupRequest.Builder, AssociateFirewallRuleGroupRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId")
            .getter(getter(AssociateFirewallRuleGroupRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(AssociateFirewallRuleGroupRequest::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AssociateFirewallRuleGroupRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(AssociateFirewallRuleGroupRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssociateFirewallRuleGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MutationProtection").getter(getter(AssociateFirewallRuleGroupRequest::mutationProtectionAsString))
            .setter(setter(Builder::mutationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(AssociateFirewallRuleGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            FIREWALL_RULE_GROUP_ID_FIELD, VPC_ID_FIELD, PRIORITY_FIELD, NAME_FIELD, MUTATION_PROTECTION_FIELD, TAGS_FIELD));

    private final String creatorRequestId;

    private final String firewallRuleGroupId;

    private final String vpcId;

    private final Integer priority;

    private final String name;

    private final String mutationProtection;

    private final List<Tag> tags;

    private AssociateFirewallRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.vpcId = builder.vpcId;
        this.priority = builder.priority;
        this.name = builder.name;
        this.mutationProtection = builder.mutationProtection;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
     * stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example,
     *         a date/time stamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * The unique identifier of the VPC that you want to associate with the rule group.
     * </p>
     * 
     * @return The unique identifier of the VPC that you want to associate with the rule group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The setting that determines the processing order of the rule group among the rule groups that you associate with
     * the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority
     * setting.
     * </p>
     * <p>
     * You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to
     * insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change
     * the priority setting for a rule group association after you create it.
     * </p>
     * <p>
     * The allowed values for <code>Priority</code> are between 100 and 9900.
     * </p>
     * 
     * @return The setting that determines the processing order of the rule group among the rule groups that you
     *         associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the
     *         lowest numeric priority setting. </p>
     *         <p>
     *         You must specify a unique priority for each rule group that you associate with a single VPC. To make it
     *         easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so
     *         on. You can change the priority setting for a rule group association after you create it.
     *         </p>
     *         <p>
     *         The allowed values for <code>Priority</code> are between 100 and 9900.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * A name that lets you identify the association, to manage and use it.
     * </p>
     * 
     * @return A name that lets you identify the association, to manage and use it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections. When you create the association, the default setting is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections. When you create the association, the default setting is
     *         <code>DISABLED</code>.
     * @see MutationProtectionStatus
     */
    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(mutationProtection);
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections. When you create the association, the default setting is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections. When you create the association, the default setting is
     *         <code>DISABLED</code>.
     * @see MutationProtectionStatus
     */
    public final String mutationProtectionAsString() {
        return mutationProtection;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to associate with the rule group association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to associate with the rule group association.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFirewallRuleGroupRequest)) {
            return false;
        }
        AssociateFirewallRuleGroupRequest other = (AssociateFirewallRuleGroupRequest) obj;
        return Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(priority(), other.priority()) && Objects.equals(name(), other.name())
                && Objects.equals(mutationProtectionAsString(), other.mutationProtectionAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFirewallRuleGroupRequest").add("CreatorRequestId", creatorRequestId())
                .add("FirewallRuleGroupId", firewallRuleGroupId()).add("VpcId", vpcId()).add("Priority", priority())
                .add("Name", name()).add("MutationProtection", mutationProtectionAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MutationProtection":
            return Optional.ofNullable(clazz.cast(mutationProtectionAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFirewallRuleGroupRequest, T> g) {
        return obj -> g.apply((AssociateFirewallRuleGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateFirewallRuleGroupRequest> {
        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
         * stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for
         *        example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The unique identifier of the firewall rule group.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * The unique identifier of the VPC that you want to associate with the rule group.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the VPC that you want to associate with the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The setting that determines the processing order of the rule group among the rule groups that you associate
         * with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric
         * priority setting.
         * </p>
         * <p>
         * You must specify a unique priority for each rule group that you associate with a single VPC. To make it
         * easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on.
         * You can change the priority setting for a rule group association after you create it.
         * </p>
         * <p>
         * The allowed values for <code>Priority</code> are between 100 and 9900.
         * </p>
         * 
         * @param priority
         *        The setting that determines the processing order of the rule group among the rule groups that you
         *        associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with
         *        the lowest numeric priority setting. </p>
         *        <p>
         *        You must specify a unique priority for each rule group that you associate with a single VPC. To make
         *        it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and
         *        so on. You can change the priority setting for a rule group association after you create it.
         *        </p>
         *        <p>
         *        The allowed values for <code>Priority</code> are between 100 and 9900.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * A name that lets you identify the association, to manage and use it.
         * </p>
         * 
         * @param name
         *        A name that lets you identify the association, to manage and use it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections. When you create the association, the default setting is
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections. When you create the association, the default setting
         *        is <code>DISABLED</code>.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(String mutationProtection);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections. When you create the association, the default setting is
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections. When you create the association, the default setting
         *        is <code>DISABLED</code>.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(MutationProtectionStatus mutationProtection);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the rule group association.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the rule group association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the rule group association.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the rule group association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the rule group association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String firewallRuleGroupId;

        private String vpcId;

        private Integer priority;

        private String name;

        private String mutationProtection;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFirewallRuleGroupRequest model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            firewallRuleGroupId(model.firewallRuleGroupId);
            vpcId(model.vpcId);
            priority(model.priority);
            name(model.name);
            mutationProtection(model.mutationProtection);
            tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        @Transient
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        @Transient
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMutationProtection() {
            return mutationProtection;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        @Override
        @Transient
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        @Transient
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFirewallRuleGroupRequest build() {
            return new AssociateFirewallRuleGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
