/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An association between a firewall rule group and a VPC, which enables DNS filtering for the VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallRuleGroupAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallRuleGroupAssociation.Builder, FirewallRuleGroupAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallRuleGroupAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FirewallRuleGroupAssociation::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(FirewallRuleGroupAssociation::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(FirewallRuleGroupAssociation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallRuleGroupAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(FirewallRuleGroupAssociation::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MutationProtection").getter(getter(FirewallRuleGroupAssociation::mutationProtectionAsString))
            .setter(setter(Builder::mutationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build())
            .build();

    private static final SdkField<String> MANAGED_OWNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedOwnerName").getter(getter(FirewallRuleGroupAssociation::managedOwnerName))
            .setter(setter(Builder::managedOwnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedOwnerName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FirewallRuleGroupAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(FirewallRuleGroupAssociation::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallRuleGroupAssociation::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(FirewallRuleGroupAssociation::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(FirewallRuleGroupAssociation::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            FIREWALL_RULE_GROUP_ID_FIELD, VPC_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, MUTATION_PROTECTION_FIELD,
            MANAGED_OWNER_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD,
            MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String firewallRuleGroupId;

    private final String vpcId;

    private final String name;

    private final Integer priority;

    private final String mutationProtection;

    private final String managedOwnerName;

    private final String status;

    private final String statusMessage;

    private final String creatorRequestId;

    private final String creationTime;

    private final String modificationTime;

    private FirewallRuleGroupAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.vpcId = builder.vpcId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.mutationProtection = builder.mutationProtection;
        this.managedOwnerName = builder.managedOwnerName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The identifier for the association.
     * </p>
     * 
     * @return The identifier for the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall rule group association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall rule group association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * The unique identifier of the VPC that is associated with the rule group.
     * </p>
     * 
     * @return The unique identifier of the VPC that is associated with the rule group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the association.
     * </p>
     * 
     * @return The name of the association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The setting that determines the processing order of the rule group among the rule groups that are associated with
     * a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting.
     * </p>
     * 
     * @return The setting that determines the processing order of the rule group among the rule groups that are
     *         associated with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest
     *         numeric priority setting.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections.
     * @see MutationProtectionStatus
     */
    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(mutationProtection);
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections.
     * @see MutationProtectionStatus
     */
    public final String mutationProtectionAsString() {
        return mutationProtection;
    }

    /**
     * <p>
     * The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager
     * to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.
     * </p>
     * 
     * @return The owner of the association, used only for associations that are not managed by you. If you use Firewall
     *         Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.
     */
    public final String managedOwnerName() {
        return managedOwnerName;
    }

    /**
     * <p>
     * The current status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the association.
     * @see FirewallRuleGroupAssociationStatus
     */
    public final FirewallRuleGroupAssociationStatus status() {
        return FirewallRuleGroupAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the association.
     * @see FirewallRuleGroupAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the response, if available.
     * </p>
     * 
     * @return Additional information about the status of the response, if available.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of running the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of running the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the association was created, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the association was last modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the association was last modified, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedOwnerName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroupAssociation)) {
            return false;
        }
        FirewallRuleGroupAssociation other = (FirewallRuleGroupAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority())
                && Objects.equals(mutationProtectionAsString(), other.mutationProtectionAsString())
                && Objects.equals(managedOwnerName(), other.managedOwnerName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallRuleGroupAssociation").add("Id", id()).add("Arn", arn())
                .add("FirewallRuleGroupId", firewallRuleGroupId()).add("VpcId", vpcId()).add("Name", name())
                .add("Priority", priority()).add("MutationProtection", mutationProtectionAsString())
                .add("ManagedOwnerName", managedOwnerName()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreatorRequestId", creatorRequestId())
                .add("CreationTime", creationTime()).add("ModificationTime", modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "MutationProtection":
            return Optional.ofNullable(clazz.cast(mutationProtectionAsString()));
        case "ManagedOwnerName":
            return Optional.ofNullable(clazz.cast(managedOwnerName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroupAssociation, T> g) {
        return obj -> g.apply((FirewallRuleGroupAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallRuleGroupAssociation> {
        /**
         * <p>
         * The identifier for the association.
         * </p>
         * 
         * @param id
         *        The identifier for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall rule group association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the firewall rule group association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the firewall rule group.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * The unique identifier of the VPC that is associated with the rule group.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the VPC that is associated with the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the association.
         * </p>
         * 
         * @param name
         *        The name of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The setting that determines the processing order of the rule group among the rule groups that are associated
         * with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority
         * setting.
         * </p>
         * 
         * @param priority
         *        The setting that determines the processing order of the rule group among the rule groups that are
         *        associated with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the
         *        lowest numeric priority setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(String mutationProtection);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(MutationProtectionStatus mutationProtection);

        /**
         * <p>
         * The owner of the association, used only for associations that are not managed by you. If you use Firewall
         * Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.
         * </p>
         * 
         * @param managedOwnerName
         *        The owner of the association, used only for associations that are not managed by you. If you use
         *        Firewall Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed
         *        owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedOwnerName(String managedOwnerName);

        /**
         * <p>
         * The current status of the association.
         * </p>
         * 
         * @param status
         *        The current status of the association.
         * @see FirewallRuleGroupAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the association.
         * </p>
         * 
         * @param status
         *        The current status of the association.
         * @see FirewallRuleGroupAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupAssociationStatus
         */
        Builder status(FirewallRuleGroupAssociationStatus status);

        /**
         * <p>
         * Additional information about the status of the response, if available.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the status of the response, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of running the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of running the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the association was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the association was last modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the association was last modified, in Unix time format and Coordinated
         *        Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String firewallRuleGroupId;

        private String vpcId;

        private String name;

        private Integer priority;

        private String mutationProtection;

        private String managedOwnerName;

        private String status;

        private String statusMessage;

        private String creatorRequestId;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroupAssociation model) {
            id(model.id);
            arn(model.arn);
            firewallRuleGroupId(model.firewallRuleGroupId);
            vpcId(model.vpcId);
            name(model.name);
            priority(model.priority);
            mutationProtection(model.mutationProtection);
            managedOwnerName(model.managedOwnerName);
            status(model.status);
            statusMessage(model.statusMessage);
            creatorRequestId(model.creatorRequestId);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        @Transient
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getMutationProtection() {
            return mutationProtection;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        @Override
        @Transient
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        @Transient
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final String getManagedOwnerName() {
            return managedOwnerName;
        }

        public final void setManagedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
        }

        @Override
        @Transient
        public final Builder managedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(FirewallRuleGroupAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        @Transient
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        @Transient
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        @Override
        public FirewallRuleGroupAssociation build() {
            return new FirewallRuleGroupAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
