/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to a <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html"
 * >CreateResolverQueryLogConfig</a>, <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html"
 * >DeleteResolverQueryLogConfig</a>, <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html"
 * >GetResolverQueryLogConfig</a>, or <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html"
 * >ListResolverQueryLogConfigs</a> request, a complex type that contains settings for one query logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverQueryLogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverQueryLogConfig.Builder, ResolverQueryLogConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResolverQueryLogConfig::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(ResolverQueryLogConfig::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResolverQueryLogConfig::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(ResolverQueryLogConfig::shareStatusAsString))
            .setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final SdkField<Integer> ASSOCIATION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AssociationCount").getter(getter(ResolverQueryLogConfig::associationCount))
            .setter(setter(Builder::associationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationCount").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ResolverQueryLogConfig::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResolverQueryLogConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(ResolverQueryLogConfig::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(ResolverQueryLogConfig::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(ResolverQueryLogConfig::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, OWNER_ID_FIELD,
            STATUS_FIELD, SHARE_STATUS_FIELD, ASSOCIATION_COUNT_FIELD, ARN_FIELD, NAME_FIELD, DESTINATION_ARN_FIELD,
            CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String ownerId;

    private final String status;

    private final String shareStatus;

    private final Integer associationCount;

    private final String arn;

    private final String name;

    private final String destinationArn;

    private final String creatorRequestId;

    private final String creationTime;

    private ResolverQueryLogConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.ownerId = builder.ownerId;
        this.status = builder.status;
        this.shareStatus = builder.shareStatus;
        this.associationCount = builder.associationCount;
        this.arn = builder.arn;
        this.name = builder.name;
        this.destinationArn = builder.destinationArn;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ID for the query logging configuration.
     * </p>
     * 
     * @return The ID for the query logging configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the account that created the query logging configuration.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the account that created the query logging configuration.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The status of the specified query logging configuration. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: Resolver is creating the query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that
     * originate in the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Resolver is deleting this query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
     * configuration. Here are two common causes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The specified destination (for example, an Amazon S3 bucket) was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Permissions don't allow sending logs to the destination.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverQueryLogConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified query logging configuration. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: Resolver is creating the query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
     *         queries that originate in the specified VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Resolver is deleting this query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
     *         configuration. Here are two common causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The specified destination (for example, an Amazon S3 bucket) was deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Permissions don't allow sending logs to the destination.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ResolverQueryLogConfigStatus
     */
    public final ResolverQueryLogConfigStatus status() {
        return ResolverQueryLogConfigStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the specified query logging configuration. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: Resolver is creating the query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that
     * originate in the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Resolver is deleting this query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
     * configuration. Here are two common causes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The specified destination (for example, an Amazon S3 bucket) was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Permissions don't allow sending logs to the destination.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverQueryLogConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified query logging configuration. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: Resolver is creating the query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
     *         queries that originate in the specified VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Resolver is deleting this query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
     *         configuration. Here are two common causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The specified destination (for example, an Amazon S3 bucket) was deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Permissions don't allow sending logs to the destination.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ResolverQueryLogConfigStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or
     * was shared with the current account by another Amazon Web Services account. Sharing is configured through
     * Resource Access Manager (RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the query logging configuration is shared with other Amazon Web Services
     *         accounts, or was shared with the current account by another Amazon Web Services account. Sharing is
     *         configured through Resource Access Manager (RAM).
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or
     * was shared with the current account by another Amazon Web Services account. Sharing is configured through
     * Resource Access Manager (RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the query logging configuration is shared with other Amazon Web Services
     *         accounts, or was shared with the current account by another Amazon Web Services account. Sharing is
     *         configured through Resource Access Manager (RAM).
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    /**
     * <p>
     * The number of VPCs that are associated with the query logging configuration.
     * </p>
     * 
     * @return The number of VPCs that are associated with the query logging configuration.
     */
    public final Integer associationCount() {
        return associationCount;
    }

    /**
     * <p>
     * The ARN for the query logging configuration.
     * </p>
     * 
     * @return The ARN for the query logging configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the query logging configuration.
     * </p>
     * 
     * @return The name of the query logging configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log
     * group, or a Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @return The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs
     *         log group, or a Kinesis Data Firehose delivery stream.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * A unique string that identifies the request that created the query logging configuration. The
     * <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the operation
     * twice.
     * </p>
     * 
     * @return A unique string that identifies the request that created the query logging configuration. The
     *         <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the
     *         operation twice.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal
     * Time (UTC).
     * </p>
     * 
     * @return The date and time that the query logging configuration was created, in Unix time format and Coordinated
     *         Universal Time (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationCount());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverQueryLogConfig)) {
            return false;
        }
        ResolverQueryLogConfig other = (ResolverQueryLogConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString())
                && Objects.equals(associationCount(), other.associationCount()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolverQueryLogConfig").add("Id", id()).add("OwnerId", ownerId())
                .add("Status", statusAsString()).add("ShareStatus", shareStatusAsString())
                .add("AssociationCount", associationCount()).add("Arn", arn()).add("Name", name())
                .add("DestinationArn", destinationArn()).add("CreatorRequestId", creatorRequestId())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        case "AssociationCount":
            return Optional.ofNullable(clazz.cast(associationCount()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverQueryLogConfig, T> g) {
        return obj -> g.apply((ResolverQueryLogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverQueryLogConfig> {
        /**
         * <p>
         * The ID for the query logging configuration.
         * </p>
         * 
         * @param id
         *        The ID for the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Web Services account ID for the account that created the query logging configuration.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID for the account that created the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The status of the specified query logging configuration. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: Resolver is creating the query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries
         * that originate in the specified VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Resolver is deleting this query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
         * configuration. Here are two common causes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The specified destination (for example, an Amazon S3 bucket) was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Permissions don't allow sending logs to the destination.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the specified query logging configuration. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: Resolver is creating the query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
         *        queries that originate in the specified VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Resolver is deleting this query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query
         *        logging configuration. Here are two common causes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The specified destination (for example, an Amazon S3 bucket) was deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Permissions don't allow sending logs to the destination.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ResolverQueryLogConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the specified query logging configuration. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: Resolver is creating the query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries
         * that originate in the specified VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Resolver is deleting this query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging
         * configuration. Here are two common causes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The specified destination (for example, an Amazon S3 bucket) was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Permissions don't allow sending logs to the destination.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the specified query logging configuration. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: Resolver is creating the query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
         *        queries that originate in the specified VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Resolver is deleting this query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query
         *        logging configuration. Here are two common causes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The specified destination (for example, an Amazon S3 bucket) was deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Permissions don't allow sending logs to the destination.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ResolverQueryLogConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigStatus
         */
        Builder status(ResolverQueryLogConfigStatus status);

        /**
         * <p>
         * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts,
         * or was shared with the current account by another Amazon Web Services account. Sharing is configured through
         * Resource Access Manager (RAM).
         * </p>
         * 
         * @param shareStatus
         *        An indication of whether the query logging configuration is shared with other Amazon Web Services
         *        accounts, or was shared with the current account by another Amazon Web Services account. Sharing is
         *        configured through Resource Access Manager (RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * An indication of whether the query logging configuration is shared with other Amazon Web Services accounts,
         * or was shared with the current account by another Amazon Web Services account. Sharing is configured through
         * Resource Access Manager (RAM).
         * </p>
         * 
         * @param shareStatus
         *        An indication of whether the query logging configuration is shared with other Amazon Web Services
         *        accounts, or was shared with the current account by another Amazon Web Services account. Sharing is
         *        configured through Resource Access Manager (RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);

        /**
         * <p>
         * The number of VPCs that are associated with the query logging configuration.
         * </p>
         * 
         * @param associationCount
         *        The number of VPCs that are associated with the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationCount(Integer associationCount);

        /**
         * <p>
         * The ARN for the query logging configuration.
         * </p>
         * 
         * @param arn
         *        The ARN for the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the query logging configuration.
         * </p>
         * 
         * @param name
         *        The name of the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log
         * group, or a Kinesis Data Firehose delivery stream.
         * </p>
         * 
         * @param destinationArn
         *        The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch
         *        Logs log group, or a Kinesis Data Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * A unique string that identifies the request that created the query logging configuration. The
         * <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the operation
         * twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request that created the query logging configuration. The
         *        <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the
         *        operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The date and time that the query logging configuration was created, in Unix time format and Coordinated
         * Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the query logging configuration was created, in Unix time format and
         *        Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String ownerId;

        private String status;

        private String shareStatus;

        private Integer associationCount;

        private String arn;

        private String name;

        private String destinationArn;

        private String creatorRequestId;

        private String creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverQueryLogConfig model) {
            id(model.id);
            ownerId(model.ownerId);
            status(model.status);
            shareStatus(model.shareStatus);
            associationCount(model.associationCount);
            arn(model.arn);
            name(model.name);
            destinationArn(model.destinationArn);
            creatorRequestId(model.creatorRequestId);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ResolverQueryLogConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        @Transient
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final Integer getAssociationCount() {
            return associationCount;
        }

        public final void setAssociationCount(Integer associationCount) {
            this.associationCount = associationCount;
        }

        @Override
        @Transient
        public final Builder associationCount(Integer associationCount) {
            this.associationCount = associationCount;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        @Transient
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        @Transient
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public ResolverQueryLogConfig build() {
            return new ResolverQueryLogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
