/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverConfigResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverConfigResponse.Builder, GetResolverConfigResponse> {
    private static final SdkField<ResolverConfig> RESOLVER_CONFIG_FIELD = SdkField
            .<ResolverConfig> builder(MarshallingType.SDK_POJO).memberName("ResolverConfig")
            .getter(getter(GetResolverConfigResponse::resolverConfig)).setter(setter(Builder::resolverConfig))
            .constructor(ResolverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_CONFIG_FIELD));

    private final ResolverConfig resolverConfig;

    private GetResolverConfigResponse(BuilderImpl builder) {
        super(builder);
        this.resolverConfig = builder.resolverConfig;
    }

    /**
     * <p>
     * Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified in the
     * <code>GetResolverConfig</code> request.
     * </p>
     * 
     * @return Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified in
     *         the <code>GetResolverConfig</code> request.
     */
    public final ResolverConfig resolverConfig() {
        return resolverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverConfigResponse)) {
            return false;
        }
        GetResolverConfigResponse other = (GetResolverConfigResponse) obj;
        return Objects.equals(resolverConfig(), other.resolverConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResolverConfigResponse").add("ResolverConfig", resolverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverConfig":
            return Optional.ofNullable(clazz.cast(resolverConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResolverConfigResponse, T> g) {
        return obj -> g.apply((GetResolverConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverConfigResponse> {
        /**
         * <p>
         * Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified in the
         * <code>GetResolverConfig</code> request.
         * </p>
         * 
         * @param resolverConfig
         *        Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified
         *        in the <code>GetResolverConfig</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverConfig(ResolverConfig resolverConfig);

        /**
         * <p>
         * Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified in the
         * <code>GetResolverConfig</code> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolverConfig.Builder} avoiding the need
         * to create one manually via {@link ResolverConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resolverConfig(ResolverConfig)}.
         * 
         * @param resolverConfig
         *        a consumer that will call methods on {@link ResolverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverConfig(ResolverConfig)
         */
        default Builder resolverConfig(Consumer<ResolverConfig.Builder> resolverConfig) {
            return resolverConfig(ResolverConfig.builder().applyMutation(resolverConfig).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverConfig resolverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverConfigResponse model) {
            super(model);
            resolverConfig(model.resolverConfig);
        }

        public final ResolverConfig.Builder getResolverConfig() {
            return resolverConfig != null ? resolverConfig.toBuilder() : null;
        }

        public final void setResolverConfig(ResolverConfig.BuilderImpl resolverConfig) {
            this.resolverConfig = resolverConfig != null ? resolverConfig.build() : null;
        }

        @Override
        public final Builder resolverConfig(ResolverConfig resolverConfig) {
            this.resolverConfig = resolverConfig;
            return this;
        }

        @Override
        public GetResolverConfigResponse build() {
            return new GetResolverConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
