/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallConfigsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListFirewallConfigsResponse.Builder, ListFirewallConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FirewallConfig>> FIREWALL_CONFIGS_FIELD = SdkField
            .<List<FirewallConfig>> builder(MarshallingType.LIST)
            .memberName("FirewallConfigs")
            .getter(getter(ListFirewallConfigsResponse::firewallConfigs))
            .setter(setter(Builder::firewallConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_CONFIGS_FIELD));

    private final String nextToken;

    private final List<FirewallConfig> firewallConfigs;

    private ListFirewallConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallConfigs = builder.firewallConfigs;
    }

    /**
     * <p>
     * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next
     * batch of objects, provide this token in your next request.
     * </p>
     * 
     * @return If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
     *         the next batch of objects, provide this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallConfigs() {
        return firewallConfigs != null && !(firewallConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private Cloud
     * (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallConfigs} method.
     * </p>
     * 
     * @return The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual
     *         Private Cloud (Amazon VPC).
     */
    public final List<FirewallConfig> firewallConfigs() {
        return firewallConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallConfigs() ? firewallConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallConfigsResponse)) {
            return false;
        }
        ListFirewallConfigsResponse other = (ListFirewallConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFirewallConfigs() == other.hasFirewallConfigs()
                && Objects.equals(firewallConfigs(), other.firewallConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallConfigsResponse").add("NextToken", nextToken())
                .add("FirewallConfigs", hasFirewallConfigs() ? firewallConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FirewallConfigs":
            return Optional.ofNullable(clazz.cast(firewallConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallConfigsResponse, T> g) {
        return obj -> g.apply((ListFirewallConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallConfigsResponse> {
        /**
         * <p>
         * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the
         * next batch of objects, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
         *        the next batch of objects, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private
         * Cloud (Amazon VPC).
         * </p>
         * 
         * @param firewallConfigs
         *        The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual
         *        Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallConfigs(Collection<FirewallConfig> firewallConfigs);

        /**
         * <p>
         * The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private
         * Cloud (Amazon VPC).
         * </p>
         * 
         * @param firewallConfigs
         *        The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual
         *        Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallConfigs(FirewallConfig... firewallConfigs);

        /**
         * <p>
         * The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private
         * Cloud (Amazon VPC).
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FirewallConfig>.Builder} avoiding
         * the need to create one manually via {@link List<FirewallConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FirewallConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #firewallConfigs(List<FirewallConfig>)}.
         * 
         * @param firewallConfigs
         *        a consumer that will call methods on {@link List<FirewallConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallConfigs(List<FirewallConfig>)
         */
        Builder firewallConfigs(Consumer<FirewallConfig.Builder>... firewallConfigs);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallConfig> firewallConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallConfigs(model.firewallConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallConfig.Builder> getFirewallConfigs() {
            List<FirewallConfig.Builder> result = FirewallConfigListCopier.copyToBuilder(this.firewallConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallConfigs(Collection<FirewallConfig.BuilderImpl> firewallConfigs) {
            this.firewallConfigs = FirewallConfigListCopier.copyFromBuilder(firewallConfigs);
        }

        @Override
        public final Builder firewallConfigs(Collection<FirewallConfig> firewallConfigs) {
            this.firewallConfigs = FirewallConfigListCopier.copy(firewallConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallConfigs(FirewallConfig... firewallConfigs) {
            firewallConfigs(Arrays.asList(firewallConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallConfigs(Consumer<FirewallConfig.Builder>... firewallConfigs) {
            firewallConfigs(Stream.of(firewallConfigs).map(c -> FirewallConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallConfigsResponse build() {
            return new ListFirewallConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
