/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverDnssecConfigsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverDnssecConfigsResponse.Builder, ListResolverDnssecConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverDnssecConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ResolverDnssecConfig>> RESOLVER_DNSSEC_CONFIGS_FIELD = SdkField
            .<List<ResolverDnssecConfig>> builder(MarshallingType.LIST)
            .memberName("ResolverDnssecConfigs")
            .getter(getter(ListResolverDnssecConfigsResponse::resolverDnssecConfigs))
            .setter(setter(Builder::resolverDnssecConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverDnssecConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverDnssecConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverDnssecConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOLVER_DNSSEC_CONFIGS_FIELD));

    private final String nextToken;

    private final List<ResolverDnssecConfig> resolverDnssecConfigs;

    private ListResolverDnssecConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resolverDnssecConfigs = builder.resolverDnssecConfigs;
    }

    /**
     * <p>
     * If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web
     * Services account, <code>NextToken</code> doesn't appear in the response.
     * </p>
     * <p>
     * If a response doesn't include the last of the configurations, you can get more configurations by submitting
     * another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">
     * ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in
     * the previous response and include it in <code>NextToken</code> in the next request.
     * </p>
     * 
     * @return If a response includes the last of the DNSSEC configurations that are associated with the current Amazon
     *         Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
     *         <p>
     *         If a response doesn't include the last of the configurations, you can get more configurations by
     *         submitting another <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html"
     *         >ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
     *         returned in the previous response and include it in <code>NextToken</code> in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolverDnssecConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResolverDnssecConfigs() {
        return resolverDnssecConfigs != null && !(resolverDnssecConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains one <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
     * >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the
     * current Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolverDnssecConfigs} method.
     * </p>
     * 
     * @return An array that contains one <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
     *         >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with
     *         the current Amazon Web Services account.
     */
    public final List<ResolverDnssecConfig> resolverDnssecConfigs() {
        return resolverDnssecConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResolverDnssecConfigs() ? resolverDnssecConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverDnssecConfigsResponse)) {
            return false;
        }
        ListResolverDnssecConfigsResponse other = (ListResolverDnssecConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResolverDnssecConfigs() == other.hasResolverDnssecConfigs()
                && Objects.equals(resolverDnssecConfigs(), other.resolverDnssecConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResolverDnssecConfigsResponse").add("NextToken", nextToken())
                .add("ResolverDnssecConfigs", hasResolverDnssecConfigs() ? resolverDnssecConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResolverDnssecConfigs":
            return Optional.ofNullable(clazz.cast(resolverDnssecConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverDnssecConfigsResponse, T> g) {
        return obj -> g.apply((ListResolverDnssecConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverDnssecConfigsResponse> {
        /**
         * <p>
         * If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web
         * Services account, <code>NextToken</code> doesn't appear in the response.
         * </p>
         * <p>
         * If a response doesn't include the last of the configurations, you can get more configurations by submitting
         * another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">
         * ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned
         * in the previous response and include it in <code>NextToken</code> in the next request.
         * </p>
         * 
         * @param nextToken
         *        If a response includes the last of the DNSSEC configurations that are associated with the current
         *        Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
         *        <p>
         *        If a response doesn't include the last of the configurations, you can get more configurations by
         *        submitting another <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html"
         *        >ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
         *        returned in the previous response and include it in <code>NextToken</code> in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
         * >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the
         * current Amazon Web Services account.
         * </p>
         * 
         * @param resolverDnssecConfigs
         *        An array that contains one <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
         *        >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with
         *        the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverDnssecConfigs(Collection<ResolverDnssecConfig> resolverDnssecConfigs);

        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
         * >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the
         * current Amazon Web Services account.
         * </p>
         * 
         * @param resolverDnssecConfigs
         *        An array that contains one <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
         *        >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with
         *        the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverDnssecConfigs(ResolverDnssecConfig... resolverDnssecConfigs);

        /**
         * <p>
         * An array that contains one <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html"
         * >ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the
         * current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ResolverDnssecConfig>.Builder}
         * avoiding the need to create one manually via {@link List<ResolverDnssecConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResolverDnssecConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #resolverDnssecConfigs(List<ResolverDnssecConfig>)}.
         * 
         * @param resolverDnssecConfigs
         *        a consumer that will call methods on {@link List<ResolverDnssecConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverDnssecConfigs(List<ResolverDnssecConfig>)
         */
        Builder resolverDnssecConfigs(Consumer<ResolverDnssecConfig.Builder>... resolverDnssecConfigs);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResolverDnssecConfig> resolverDnssecConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverDnssecConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            resolverDnssecConfigs(model.resolverDnssecConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResolverDnssecConfig.Builder> getResolverDnssecConfigs() {
            List<ResolverDnssecConfig.Builder> result = ResolverDnssecConfigListCopier.copyToBuilder(this.resolverDnssecConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolverDnssecConfigs(Collection<ResolverDnssecConfig.BuilderImpl> resolverDnssecConfigs) {
            this.resolverDnssecConfigs = ResolverDnssecConfigListCopier.copyFromBuilder(resolverDnssecConfigs);
        }

        @Override
        public final Builder resolverDnssecConfigs(Collection<ResolverDnssecConfig> resolverDnssecConfigs) {
            this.resolverDnssecConfigs = ResolverDnssecConfigListCopier.copy(resolverDnssecConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverDnssecConfigs(ResolverDnssecConfig... resolverDnssecConfigs) {
            resolverDnssecConfigs(Arrays.asList(resolverDnssecConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverDnssecConfigs(Consumer<ResolverDnssecConfig.Builder>... resolverDnssecConfigs) {
            resolverDnssecConfigs(Stream.of(resolverDnssecConfigs)
                    .map(c -> ResolverDnssecConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResolverDnssecConfigsResponse build() {
            return new ListResolverDnssecConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
