/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverConfigRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateResolverConfigRequest.Builder, UpdateResolverConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateResolverConfigRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> AUTODEFINED_REVERSE_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutodefinedReverseFlag").getter(getter(UpdateResolverConfigRequest::autodefinedReverseFlagAsString))
            .setter(setter(Builder::autodefinedReverseFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutodefinedReverseFlag").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            AUTODEFINED_REVERSE_FLAG_FIELD));

    private final String resourceId;

    private final String autodefinedReverseFlag;

    private UpdateResolverConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.autodefinedReverseFlag = builder.autodefinedReverseFlag;
    }

    /**
     * <p>
     * Resource ID of the Amazon VPC that you want to update the Resolver configuration for.
     * </p>
     * 
     * @return Resource ID of the Amazon VPC that you want to update the Resolver configuration for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by
     * default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     * <i>Amazon EC2 guide</i>.
     * </p>
     * <note>
     * <p>
     * It can take some time for the status change to be completed.
     * </p>
     * </note>
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autodefinedReverseFlag} will return {@link AutodefinedReverseFlag#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autodefinedReverseFlagAsString}.
     * </p>
     * 
     * @return Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
     *         enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon EC2 guide</i>.</p> <note>
     *         <p>
     *         It can take some time for the status change to be completed.
     *         </p>
     *         </note>
     * @see AutodefinedReverseFlag
     */
    public final AutodefinedReverseFlag autodefinedReverseFlag() {
        return AutodefinedReverseFlag.fromValue(autodefinedReverseFlag);
    }

    /**
     * <p>
     * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by
     * default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     * <i>Amazon EC2 guide</i>.
     * </p>
     * <note>
     * <p>
     * It can take some time for the status change to be completed.
     * </p>
     * </note>
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autodefinedReverseFlag} will return {@link AutodefinedReverseFlag#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autodefinedReverseFlagAsString}.
     * </p>
     * 
     * @return Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
     *         enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon EC2 guide</i>.</p> <note>
     *         <p>
     *         It can take some time for the status change to be completed.
     *         </p>
     *         </note>
     * @see AutodefinedReverseFlag
     */
    public final String autodefinedReverseFlagAsString() {
        return autodefinedReverseFlag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(autodefinedReverseFlagAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverConfigRequest)) {
            return false;
        }
        UpdateResolverConfigRequest other = (UpdateResolverConfigRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(autodefinedReverseFlagAsString(), other.autodefinedReverseFlagAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverConfigRequest").add("ResourceId", resourceId())
                .add("AutodefinedReverseFlag", autodefinedReverseFlagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "AutodefinedReverseFlag":
            return Optional.ofNullable(clazz.cast(autodefinedReverseFlagAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverConfigRequest, T> g) {
        return obj -> g.apply((UpdateResolverConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResolverConfigRequest> {
        /**
         * <p>
         * Resource ID of the Amazon VPC that you want to update the Resolver configuration for.
         * </p>
         * 
         * @param resourceId
         *        Resource ID of the Amazon VPC that you want to update the Resolver configuration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled
         * by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon EC2 guide</i>.
         * </p>
         * <note>
         * <p>
         * It can take some time for the status change to be completed.
         * </p>
         * </note>
         * <p/>
         * 
         * @param autodefinedReverseFlag
         *        Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
         *        enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon EC2 guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        It can take some time for the status change to be completed.
         *        </p>
         *        </note>
         * @see AutodefinedReverseFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutodefinedReverseFlag
         */
        Builder autodefinedReverseFlag(String autodefinedReverseFlag);

        /**
         * <p>
         * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled
         * by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon EC2 guide</i>.
         * </p>
         * <note>
         * <p>
         * It can take some time for the status change to be completed.
         * </p>
         * </note>
         * <p/>
         * 
         * @param autodefinedReverseFlag
         *        Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
         *        enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon EC2 guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        It can take some time for the status change to be completed.
         *        </p>
         *        </note>
         * @see AutodefinedReverseFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutodefinedReverseFlag
         */
        Builder autodefinedReverseFlag(AutodefinedReverseFlag autodefinedReverseFlag);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String autodefinedReverseFlag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverConfigRequest model) {
            super(model);
            resourceId(model.resourceId);
            autodefinedReverseFlag(model.autodefinedReverseFlag);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getAutodefinedReverseFlag() {
            return autodefinedReverseFlag;
        }

        public final void setAutodefinedReverseFlag(String autodefinedReverseFlag) {
            this.autodefinedReverseFlag = autodefinedReverseFlag;
        }

        @Override
        public final Builder autodefinedReverseFlag(String autodefinedReverseFlag) {
            this.autodefinedReverseFlag = autodefinedReverseFlag;
            return this;
        }

        @Override
        public final Builder autodefinedReverseFlag(AutodefinedReverseFlag autodefinedReverseFlag) {
            this.autodefinedReverseFlag(autodefinedReverseFlag == null ? null : autodefinedReverseFlag.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverConfigRequest build() {
            return new UpdateResolverConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
