/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single firewall rule in a rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallRule implements SdkPojo, Serializable, ToCopyableBuilder<FirewallRule.Builder, FirewallRule> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(FirewallRule::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallDomainListId").getter(getter(FirewallRule::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(FirewallRule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(FirewallRule::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockResponse").getter(getter(FirewallRule::blockResponseAsString))
            .setter(setter(Builder::blockResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockResponse").build()).build();

    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockOverrideDomain").getter(getter(FirewallRule::blockOverrideDomain))
            .setter(setter(Builder::blockOverrideDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDomain").build())
            .build();

    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockOverrideDnsType").getter(getter(FirewallRule::blockOverrideDnsTypeAsString))
            .setter(setter(Builder::blockOverrideDnsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDnsType").build())
            .build();

    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockOverrideTtl").getter(getter(FirewallRule::blockOverrideTtl))
            .setter(setter(Builder::blockOverrideTtl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideTtl").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallRule::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(FirewallRule::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(FirewallRule::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ID_FIELD,
            FIREWALL_DOMAIN_LIST_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, ACTION_FIELD, BLOCK_RESPONSE_FIELD,
            BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_TTL_FIELD, CREATOR_REQUEST_ID_FIELD,
            CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firewallRuleGroupId;

    private final String firewallDomainListId;

    private final String name;

    private final Integer priority;

    private final String action;

    private final String blockResponse;

    private final String blockOverrideDomain;

    private final String blockOverrideDnsType;

    private final Integer blockOverrideTtl;

    private final String creatorRequestId;

    private final String creationTime;

    private final String modificationTime;

    private FirewallRule(BuilderImpl builder) {
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.action = builder.action;
        this.blockResponse = builder.blockResponse;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group of the rule.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group of the rule.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * The ID of the domain list that's used in the rule.
     * </p>
     * 
     * @return The ID of the domain list that's used in the rule.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall
     * processes the rules in a rule group by order of priority, starting from the lowest setting.
     * </p>
     * 
     * @return The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall
     *         processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain
     * list:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW</code> - Permit the request to go through.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the
     * rule's <code>BlockResponse</code> setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
     *         domain list:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW</code> - Permit the request to go through.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided
     *         in the rule's <code>BlockResponse</code> setting.
     *         </p>
     *         </li>
     * @see Action
     */
    public final Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain
     * list:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW</code> - Permit the request to go through.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the
     * rule's <code>BlockResponse</code> setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
     *         domain list:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW</code> - Permit the request to go through.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided
     *         in the rule's <code>BlockResponse</code> setting.
     *         </p>
     *         </li>
     * @see Action
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details
     * in the rule's <code>BlockOverride*</code> settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link BlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The way that you want DNS Firewall to block the request. Used for the rule action setting
     *         <code>BLOCK</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for
     *         it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling
     *         details in the rule's <code>BlockOverride*</code> settings.
     *         </p>
     *         </li>
     * @see BlockResponse
     */
    public final BlockResponse blockResponse() {
        return BlockResponse.fromValue(blockResponse);
    }

    /**
     * <p>
     * The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details
     * in the rule's <code>BlockOverride*</code> settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link BlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The way that you want DNS Firewall to block the request. Used for the rule action setting
     *         <code>BLOCK</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for
     *         it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling
     *         details in the rule's <code>BlockOverride*</code> settings.
     *         </p>
     *         </li>
     * @see BlockResponse
     */
    public final String blockResponseAsString() {
        return blockResponse;
    }

    /**
     * <p>
     * The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a
     * <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
     * </p>
     * 
     * @return The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code>
     *         with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
     */
    public final String blockOverrideDomain() {
        return blockOverrideDomain;
    }

    /**
     * <p>
     * The DNS record's type. This determines the format of the record value that you provided in
     * <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code>
     * setting of <code>OVERRIDE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record's type. This determines the format of the record value that you provided in
     *         <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
     *         <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
     * @see BlockOverrideDnsType
     */
    public final BlockOverrideDnsType blockOverrideDnsType() {
        return BlockOverrideDnsType.fromValue(blockOverrideDnsType);
    }

    /**
     * <p>
     * The DNS record's type. This determines the format of the record value that you provided in
     * <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code>
     * setting of <code>OVERRIDE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record's type. This determines the format of the record value that you provided in
     *         <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
     *         <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
     * @see BlockOverrideDnsType
     */
    public final String blockOverrideDnsTypeAsString() {
        return blockOverrideDnsType;
    }

    /**
     * <p>
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override
     * record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of
     * <code>OVERRIDE</code>.
     * </p>
     * 
     * @return The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided
     *         override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of
     *         <code>OVERRIDE</code>.
     */
    public final Integer blockOverrideTtl() {
        return blockOverrideTtl;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of executing the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRule)) {
            return false;
        }
        FirewallRule other = (FirewallRule) obj;
        return Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId())
                && Objects.equals(firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(blockResponseAsString(), other.blockResponseAsString())
                && Objects.equals(blockOverrideDomain(), other.blockOverrideDomain())
                && Objects.equals(blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString())
                && Objects.equals(blockOverrideTtl(), other.blockOverrideTtl())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallRule").add("FirewallRuleGroupId", firewallRuleGroupId())
                .add("FirewallDomainListId", firewallDomainListId()).add("Name", name()).add("Priority", priority())
                .add("Action", actionAsString()).add("BlockResponse", blockResponseAsString())
                .add("BlockOverrideDomain", blockOverrideDomain()).add("BlockOverrideDnsType", blockOverrideDnsTypeAsString())
                .add("BlockOverrideTtl", blockOverrideTtl()).add("CreatorRequestId", creatorRequestId())
                .add("CreationTime", creationTime()).add("ModificationTime", modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "FirewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "BlockResponse":
            return Optional.ofNullable(clazz.cast(blockResponseAsString()));
        case "BlockOverrideDomain":
            return Optional.ofNullable(clazz.cast(blockOverrideDomain()));
        case "BlockOverrideDnsType":
            return Optional.ofNullable(clazz.cast(blockOverrideDnsTypeAsString()));
        case "BlockOverrideTtl":
            return Optional.ofNullable(clazz.cast(blockOverrideTtl()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRule, T> g) {
        return obj -> g.apply((FirewallRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallRule> {
        /**
         * <p>
         * The unique identifier of the firewall rule group of the rule.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * The ID of the domain list that's used in the rule.
         * </p>
         * 
         * @param firewallDomainListId
         *        The ID of the domain list that's used in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall
         * processes the rules in a rule group by order of priority, starting from the lowest setting.
         * </p>
         * 
         * @param priority
         *        The priority of the rule in the rule group. This value must be unique within the rule group. DNS
         *        Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
         * domain list:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW</code> - Permit the request to go through.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in
         * the rule's <code>BlockResponse</code> setting.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the
         *        rule's domain list:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW</code> - Permit the request to go through.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are
         *        provided in the rule's <code>BlockResponse</code> setting.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
         * domain list:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW</code> - Permit the request to go through.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in
         * the rule's <code>BlockResponse</code> setting.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the
         *        rule's domain list:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW</code> - Permit the request to go through.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are
         *        provided in the rule's <code>BlockResponse</code> setting.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling
         * details in the rule's <code>BlockOverride*</code> settings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blockResponse
         *        The way that you want DNS Firewall to block the request. Used for the rule action setting
         *        <code>BLOCK</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NODATA</code> - Respond indicating that the query was successful, but no response is available
         *        for it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom
         *        handling details in the rule's <code>BlockOverride*</code> settings.
         *        </p>
         *        </li>
         * @see BlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockResponse
         */
        Builder blockResponse(String blockResponse);

        /**
         * <p>
         * The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling
         * details in the rule's <code>BlockOverride*</code> settings.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blockResponse
         *        The way that you want DNS Firewall to block the request. Used for the rule action setting
         *        <code>BLOCK</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NODATA</code> - Respond indicating that the query was successful, but no response is available
         *        for it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom
         *        handling details in the rule's <code>BlockOverride*</code> settings.
         *        </p>
         *        </li>
         * @see BlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockResponse
         */
        Builder blockResponse(BlockResponse blockResponse);

        /**
         * <p>
         * The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with
         * a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * </p>
         * 
         * @param blockOverrideDomain
         *        The custom DNS record to send back in response to the query. Used for the rule action
         *        <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideDomain(String blockOverrideDomain);

        /**
         * <p>
         * The DNS record's type. This determines the format of the record value that you provided in
         * <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
         * <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record's type. This determines the format of the record value that you provided in
         *        <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
         *        <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * @see BlockOverrideDnsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsType
         */
        Builder blockOverrideDnsType(String blockOverrideDnsType);

        /**
         * <p>
         * The DNS record's type. This determines the format of the record value that you provided in
         * <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
         * <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record's type. This determines the format of the record value that you provided in
         *        <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a
         *        <code>BlockResponse</code> setting of <code>OVERRIDE</code>.
         * @see BlockOverrideDnsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsType
         */
        Builder blockOverrideDnsType(BlockOverrideDnsType blockOverrideDnsType);

        /**
         * <p>
         * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided
         * override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of
         * <code>OVERRIDE</code>.
         * </p>
         * 
         * @param blockOverrideTtl
         *        The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided
         *        override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting
         *        of <code>OVERRIDE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideTtl(Integer blockOverrideTtl);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of executing the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of executing the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String firewallRuleGroupId;

        private String firewallDomainListId;

        private String name;

        private Integer priority;

        private String action;

        private String blockResponse;

        private String blockOverrideDomain;

        private String blockOverrideDnsType;

        private Integer blockOverrideTtl;

        private String creatorRequestId;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRule model) {
            firewallRuleGroupId(model.firewallRuleGroupId);
            firewallDomainListId(model.firewallDomainListId);
            name(model.name);
            priority(model.priority);
            action(model.action);
            blockResponse(model.blockResponse);
            blockOverrideDomain(model.blockOverrideDomain);
            blockOverrideDnsType(model.blockOverrideDnsType);
            blockOverrideTtl(model.blockOverrideTtl);
            creatorRequestId(model.creatorRequestId);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        @Transient
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        @Transient
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockResponse() {
            return blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        @Transient
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        @Transient
        public final Builder blockResponse(BlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        @Transient
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        @Transient
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        @Transient
        public final Builder blockOverrideDnsType(BlockOverrideDnsType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        @Transient
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        @Transient
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        @Transient
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        @Override
        public FirewallRule build() {
            return new FirewallRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
