/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverConfig;

public class ListResolverConfigsPublisher
implements SdkPublisher<ListResolverConfigsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverConfigsPublisher(Route53ResolverAsyncClient client, ListResolverConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverConfigsPublisher(Route53ResolverAsyncClient client, ListResolverConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolverConfig> resolverConfigs() {
        Function<ListResolverConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverConfigs() != null) {
                return response.resolverConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolverConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolverConfigsResponseFetcher
    implements AsyncPageFetcher<ListResolverConfigsResponse> {
        private ListResolverConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverConfigsResponse> nextPage(ListResolverConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverConfigsPublisher.this.client.listResolverConfigs(ListResolverConfigsPublisher.this.firstRequest);
            }
            return ListResolverConfigsPublisher.this.client.listResolverConfigs((ListResolverConfigsRequest)((Object)ListResolverConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

