/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.route53resolver.internal.Route53ResolverServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53resolver.model.AccessDeniedException;
import software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ConflictException;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.InternalServiceErrorException;
import software.amazon.awssdk.services.route53resolver.model.InvalidNextTokenException;
import software.amazon.awssdk.services.route53resolver.model.InvalidParameterException;
import software.amazon.awssdk.services.route53resolver.model.InvalidPolicyDocumentException;
import software.amazon.awssdk.services.route53resolver.model.InvalidRequestException;
import software.amazon.awssdk.services.route53resolver.model.InvalidTagException;
import software.amazon.awssdk.services.route53resolver.model.LimitExceededException;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.ResourceExistsException;
import software.amazon.awssdk.services.route53resolver.model.ResourceInUseException;
import software.amazon.awssdk.services.route53resolver.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53resolver.model.ResourceUnavailableException;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverException;
import software.amazon.awssdk.services.route53resolver.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53resolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.ThrottlingException;
import software.amazon.awssdk.services.route53resolver.model.UnknownResourceException;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ValidationException;
import software.amazon.awssdk.services.route53resolver.transform.AssociateFirewallRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.AssociateResolverEndpointIpAddressRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.AssociateResolverQueryLogConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.AssociateResolverRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateFirewallRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateOutpostResolverRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateResolverEndpointRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateResolverQueryLogConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.CreateResolverRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteFirewallRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteOutpostResolverRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteResolverEndpointRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteResolverQueryLogConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DeleteResolverRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DisassociateFirewallRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DisassociateResolverEndpointIpAddressRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DisassociateResolverQueryLogConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.DisassociateResolverRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetFirewallConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetFirewallRuleGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetFirewallRuleGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetFirewallRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetOutpostResolverRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverDnssecConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverEndpointRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverQueryLogConfigAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverQueryLogConfigPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverQueryLogConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverRuleAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.GetResolverRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ImportFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallDomainListsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallRuleGroupAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListFirewallRulesRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListOutpostResolversRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverDnssecConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverEndpointIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverEndpointsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverQueryLogConfigAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverQueryLogConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverRuleAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListResolverRulesRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.PutFirewallRuleGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.PutResolverQueryLogConfigPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.PutResolverRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateFirewallConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateFirewallRuleGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateOutpostResolverRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateResolverConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateResolverDnssecConfigRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateResolverEndpointRequestMarshaller;
import software.amazon.awssdk.services.route53resolver.transform.UpdateResolverRuleRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Route53ResolverAsyncClient}.
 *
 * @see Route53ResolverAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoute53ResolverAsyncClient implements Route53ResolverAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoute53ResolverAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53ResolverAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a <a>FirewallRuleGroup</a> with a VPC, to provide DNS filtering for the VPC.
     * </p>
     *
     * @param associateFirewallRuleGroupRequest
     * @return A Java Future containing the result of the AssociateFirewallRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateFirewallRuleGroupResponse> associateFirewallRuleGroup(
            AssociateFirewallRuleGroupRequest associateFirewallRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateFirewallRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFirewallRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFirewallRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateFirewallRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateFirewallRuleGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateFirewallRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateFirewallRuleGroupRequest, AssociateFirewallRuleGroupResponse>()
                            .withOperationName("AssociateFirewallRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateFirewallRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateFirewallRuleGroupRequest));
            CompletableFuture<AssociateFirewallRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
     * submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To remove an IP address from an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html"
     * >DisassociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param associateResolverEndpointIpAddressRequest
     * @return A Java Future containing the result of the AssociateResolverEndpointIpAddress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateResolverEndpointIpAddressResponse> associateResolverEndpointIpAddress(
            AssociateResolverEndpointIpAddressRequest associateResolverEndpointIpAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateResolverEndpointIpAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateResolverEndpointIpAddressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateResolverEndpointIpAddress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateResolverEndpointIpAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateResolverEndpointIpAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateResolverEndpointIpAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateResolverEndpointIpAddressRequest, AssociateResolverEndpointIpAddressResponse>()
                            .withOperationName("AssociateResolverEndpointIpAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateResolverEndpointIpAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateResolverEndpointIpAddressRequest));
            CompletableFuture<AssociateResolverEndpointIpAddressResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that
     * originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To
     * associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request
     * for each VPC.
     * </p>
     * <note>
     * <p>
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     * </p>
     * </note>
     * <p>
     * To remove a VPC from a query logging configuration, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     *
     * @param associateResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the AssociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateResolverQueryLogConfigResponse> associateResolverQueryLogConfig(
            AssociateResolverQueryLogConfigRequest associateResolverQueryLogConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateResolverQueryLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateResolverQueryLogConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateResolverQueryLogConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateResolverQueryLogConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateResolverQueryLogConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateResolverQueryLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateResolverQueryLogConfigRequest, AssociateResolverQueryLogConfigResponse>()
                            .withOperationName("AssociateResolverQueryLogConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateResolverQueryLogConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateResolverQueryLogConfigRequest));
            CompletableFuture<AssociateResolverQueryLogConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
     * for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
     * IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html"
     * >CreateResolverRule</a>.
     * </p>
     *
     * @param associateResolverRuleRequest
     * @return A Java Future containing the result of the AssociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.AssociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateResolverRuleResponse> associateResolverRule(
            AssociateResolverRuleRequest associateResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateResolverRuleRequest, AssociateResolverRuleResponse>()
                            .withOperationName("AssociateResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateResolverRuleRequest));
            CompletableFuture<AssociateResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new
     * list with a file, using <a>ImportFirewallDomains</a>, or with domain strings, using <a>UpdateFirewallDomains</a>.
     * </p>
     *
     * @param createFirewallDomainListRequest
     * @return A Java Future containing the result of the CreateFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFirewallDomainListResponse> createFirewallDomainList(
            CreateFirewallDomainListRequest createFirewallDomainListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallDomainList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFirewallDomainListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFirewallDomainListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallDomainListRequest, CreateFirewallDomainListResponse>()
                            .withOperationName("CreateFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFirewallDomainListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFirewallDomainListRequest));
            CompletableFuture<CreateFirewallDomainListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     * </p>
     *
     * @param createFirewallRuleRequest
     * @return A Java Future containing the result of the CreateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFirewallRuleResponse> createFirewallRule(CreateFirewallRuleRequest createFirewallRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFirewallRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFirewallRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallRuleRequest, CreateFirewallRuleResponse>()
                            .withOperationName("CreateFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFirewallRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFirewallRuleRequest));
            CompletableFuture<CreateFirewallRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new
     * rule group by calling <a>CreateFirewallRule</a>.
     * </p>
     *
     * @param createFirewallRuleGroupRequest
     * @return A Java Future containing the result of the CreateFirewallRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFirewallRuleGroupResponse> createFirewallRuleGroup(
            CreateFirewallRuleGroupRequest createFirewallRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFirewallRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFirewallRuleGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFirewallRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallRuleGroupRequest, CreateFirewallRuleGroupResponse>()
                            .withOperationName("CreateFirewallRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFirewallRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFirewallRuleGroupRequest));
            CompletableFuture<CreateFirewallRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Route 53 Resolver on an Outpost.
     * </p>
     *
     * @param createOutpostResolverRequest
     * @return A Java Future containing the result of the CreateOutpostResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Fulfilling the request would cause one or more quotas to be exceeded.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOutpostResolverResponse> createOutpostResolver(
            CreateOutpostResolverRequest createOutpostResolverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOutpostResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOutpostResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOutpostResolver");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOutpostResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOutpostResolverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOutpostResolverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOutpostResolverRequest, CreateOutpostResolverResponse>()
                            .withOperationName("CreateOutpostResolver").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOutpostResolverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOutpostResolverRequest));
            CompletableFuture<CreateOutpostResolverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param createResolverEndpointRequest
     * @return A Java Future containing the result of the CreateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResolverEndpointResponse> createResolverEndpoint(
            CreateResolverEndpointRequest createResolverEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResolverEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResolverEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResolverEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResolverEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResolverEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResolverEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResolverEndpointRequest, CreateResolverEndpointResponse>()
                            .withOperationName("CreateResolverEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResolverEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResolverEndpointRequest));
            CompletableFuture<CreateResolverEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that
     * originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging
     * configuration.
     * </p>
     * <p>
     * To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
     * >AssociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web
     * Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that
     * Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with
     * the configuration.
     * </p>
     *
     * @param createResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the CreateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResolverQueryLogConfigResponse> createResolverQueryLogConfig(
            CreateResolverQueryLogConfigRequest createResolverQueryLogConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResolverQueryLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResolverQueryLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResolverQueryLogConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResolverQueryLogConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResolverQueryLogConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResolverQueryLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResolverQueryLogConfigRequest, CreateResolverQueryLogConfigResponse>()
                            .withOperationName("CreateResolverQueryLogConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResolverQueryLogConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResolverQueryLogConfigRequest));
            CompletableFuture<CreateResolverQueryLogConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one
     * domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     * </p>
     *
     * @param createResolverRuleRequest
     * @return A Java Future containing the result of the CreateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.CreateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResolverRuleResponse> createResolverRule(CreateResolverRuleRequest createResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResolverRuleRequest, CreateResolverRuleResponse>()
                            .withOperationName("CreateResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResolverRuleRequest));
            CompletableFuture<CreateResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified domain list.
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     * @return A Java Future containing the result of the DeleteFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFirewallDomainListResponse> deleteFirewallDomainList(
            DeleteFirewallDomainListRequest deleteFirewallDomainListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallDomainList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFirewallDomainListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFirewallDomainListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallDomainListRequest, DeleteFirewallDomainListResponse>()
                            .withOperationName("DeleteFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFirewallDomainListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFirewallDomainListRequest));
            CompletableFuture<DeleteFirewallDomainListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified firewall rule.
     * </p>
     *
     * @param deleteFirewallRuleRequest
     * @return A Java Future containing the result of the DeleteFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFirewallRuleResponse> deleteFirewallRule(DeleteFirewallRuleRequest deleteFirewallRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFirewallRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFirewallRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallRuleRequest, DeleteFirewallRuleResponse>()
                            .withOperationName("DeleteFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFirewallRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFirewallRuleRequest));
            CompletableFuture<DeleteFirewallRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified firewall rule group.
     * </p>
     *
     * @param deleteFirewallRuleGroupRequest
     * @return A Java Future containing the result of the DeleteFirewallRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFirewallRuleGroupResponse> deleteFirewallRuleGroup(
            DeleteFirewallRuleGroupRequest deleteFirewallRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFirewallRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFirewallRuleGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFirewallRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallRuleGroupRequest, DeleteFirewallRuleGroupResponse>()
                            .withOperationName("DeleteFirewallRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFirewallRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFirewallRuleGroupRequest));
            CompletableFuture<DeleteFirewallRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Resolver on the Outpost.
     * </p>
     *
     * @param deleteOutpostResolverRequest
     * @return A Java Future containing the result of the DeleteOutpostResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOutpostResolverResponse> deleteOutpostResolver(
            DeleteOutpostResolverRequest deleteOutpostResolverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOutpostResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOutpostResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutpostResolver");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOutpostResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOutpostResolverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOutpostResolverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOutpostResolverRequest, DeleteOutpostResolverResponse>()
                            .withOperationName("DeleteOutpostResolver").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOutpostResolverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOutpostResolverRequest));
            CompletableFuture<DeleteOutpostResolverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an
     * outbound Resolver endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteResolverEndpointRequest
     * @return A Java Future containing the result of the DeleteResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResolverEndpointResponse> deleteResolverEndpoint(
            DeleteResolverEndpointRequest deleteResolverEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResolverEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResolverEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResolverEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResolverEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResolverEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResolverEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse>()
                            .withOperationName("DeleteResolverEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResolverEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResolverEndpointRequest));
            CompletableFuture<DeleteResolverEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for
     * all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging
     * configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with
     * the shared configuration.
     * </p>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must
     * stop sharing the configuration before you can delete a configuration. The accounts that you shared the
     * configuration with can first disassociate VPCs that they associated with the configuration, but that's not
     * necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the
     * configuration.
     * </p>
     *
     * @param deleteResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the DeleteResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResolverQueryLogConfigResponse> deleteResolverQueryLogConfig(
            DeleteResolverQueryLogConfigRequest deleteResolverQueryLogConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResolverQueryLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResolverQueryLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResolverQueryLogConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResolverQueryLogConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResolverQueryLogConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResolverQueryLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResolverQueryLogConfigRequest, DeleteResolverQueryLogConfigResponse>()
                            .withOperationName("DeleteResolverQueryLogConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResolverQueryLogConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResolverQueryLogConfigRequest));
            CompletableFuture<DeleteResolverQueryLogConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that
     * you associated the Resolver rule with. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
     * >DisassociateResolverRule</a>.
     * </p>
     *
     * @param deleteResolverRuleRequest
     * @return A Java Future containing the result of the DeleteResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceInUseException The resource that you tried to update or delete is currently in use.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DeleteResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResolverRuleResponse> deleteResolverRule(DeleteResolverRuleRequest deleteResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResolverRuleRequest, DeleteResolverRuleResponse>()
                            .withOperationName("DeleteResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResolverRuleRequest));
            CompletableFuture<DeleteResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a <a>FirewallRuleGroup</a> from a VPC, to remove DNS filtering from the VPC.
     * </p>
     *
     * @param disassociateFirewallRuleGroupRequest
     * @return A Java Future containing the result of the DisassociateFirewallRuleGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFirewallRuleGroupResponse> disassociateFirewallRuleGroup(
            DisassociateFirewallRuleGroupRequest disassociateFirewallRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateFirewallRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFirewallRuleGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFirewallRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFirewallRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFirewallRuleGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFirewallRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFirewallRuleGroupRequest, DisassociateFirewallRuleGroupResponse>()
                            .withOperationName("DisassociateFirewallRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateFirewallRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateFirewallRuleGroupRequest));
            CompletableFuture<DisassociateFirewallRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP
     * address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To add an IP address to an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html"
     * >AssociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param disassociateResolverEndpointIpAddressRequest
     * @return A Java Future containing the result of the DisassociateResolverEndpointIpAddress operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceExistsException The resource that you tried to create already exists.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateResolverEndpointIpAddressResponse> disassociateResolverEndpointIpAddress(
            DisassociateResolverEndpointIpAddressRequest disassociateResolverEndpointIpAddressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateResolverEndpointIpAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateResolverEndpointIpAddressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateResolverEndpointIpAddress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateResolverEndpointIpAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateResolverEndpointIpAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateResolverEndpointIpAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateResolverEndpointIpAddressRequest, DisassociateResolverEndpointIpAddressResponse>()
                            .withOperationName("DisassociateResolverEndpointIpAddress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateResolverEndpointIpAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateResolverEndpointIpAddressRequest));
            CompletableFuture<DisassociateResolverEndpointIpAddressResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a VPC from a query logging configuration.
     * </p>
     * <note>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be
     * disassociated from the configuration in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can stop sharing the configuration.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param disassociateResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the DisassociateResolverQueryLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverQueryLogConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateResolverQueryLogConfigResponse> disassociateResolverQueryLogConfig(
            DisassociateResolverQueryLogConfigRequest disassociateResolverQueryLogConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateResolverQueryLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateResolverQueryLogConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateResolverQueryLogConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateResolverQueryLogConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateResolverQueryLogConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateResolverQueryLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateResolverQueryLogConfigRequest, DisassociateResolverQueryLogConfigResponse>()
                            .withOperationName("DisassociateResolverQueryLogConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateResolverQueryLogConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateResolverQueryLogConfigRequest));
            CompletableFuture<DisassociateResolverQueryLogConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the association between a specified Resolver rule and a specified VPC.
     * </p>
     * <important>
     * <p>
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that
     * you specified in the Resolver rule.
     * </p>
     * </important>
     *
     * @param disassociateResolverRuleRequest
     * @return A Java Future containing the result of the DisassociateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.DisassociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateResolverRuleResponse> disassociateResolverRule(
            DisassociateResolverRuleRequest disassociateResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateResolverRuleRequest, DisassociateResolverRuleResponse>()
                            .withOperationName("DisassociateResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateResolverRuleRequest));
            CompletableFuture<DisassociateResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon
     * Virtual Private Cloud (Amazon VPC).
     * </p>
     *
     * @param getFirewallConfigRequest
     * @return A Java Future containing the result of the GetFirewallConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFirewallConfigResponse> getFirewallConfig(GetFirewallConfigRequest getFirewallConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFirewallConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFirewallConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFirewallConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFirewallConfigRequest, GetFirewallConfigResponse>()
                            .withOperationName("GetFirewallConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFirewallConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFirewallConfigRequest));
            CompletableFuture<GetFirewallConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified firewall domain list.
     * </p>
     *
     * @param getFirewallDomainListRequest
     * @return A Java Future containing the result of the GetFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFirewallDomainListResponse> getFirewallDomainList(
            GetFirewallDomainListRequest getFirewallDomainListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallDomainList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFirewallDomainListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFirewallDomainListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFirewallDomainListRequest, GetFirewallDomainListResponse>()
                            .withOperationName("GetFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFirewallDomainListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFirewallDomainListRequest));
            CompletableFuture<GetFirewallDomainListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified firewall rule group.
     * </p>
     *
     * @param getFirewallRuleGroupRequest
     * @return A Java Future containing the result of the GetFirewallRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFirewallRuleGroupResponse> getFirewallRuleGroup(
            GetFirewallRuleGroupRequest getFirewallRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFirewallRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFirewallRuleGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFirewallRuleGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFirewallRuleGroupRequest, GetFirewallRuleGroupResponse>()
                            .withOperationName("GetFirewallRuleGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFirewallRuleGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFirewallRuleGroupRequest));
            CompletableFuture<GetFirewallRuleGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can
     * have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     * </p>
     *
     * @param getFirewallRuleGroupAssociationRequest
     * @return A Java Future containing the result of the GetFirewallRuleGroupAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetFirewallRuleGroupAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFirewallRuleGroupAssociationResponse> getFirewallRuleGroupAssociation(
            GetFirewallRuleGroupAssociationRequest getFirewallRuleGroupAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallRuleGroupAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFirewallRuleGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallRuleGroupAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFirewallRuleGroupAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFirewallRuleGroupAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFirewallRuleGroupAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFirewallRuleGroupAssociationRequest, GetFirewallRuleGroupAssociationResponse>()
                            .withOperationName("GetFirewallRuleGroupAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFirewallRuleGroupAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFirewallRuleGroupAssociationRequest));
            CompletableFuture<GetFirewallRuleGroupAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group.
     * You can use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     *
     * @param getFirewallRuleGroupPolicyRequest
     * @return A Java Future containing the result of the GetFirewallRuleGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFirewallRuleGroupPolicyResponse> getFirewallRuleGroupPolicy(
            GetFirewallRuleGroupPolicyRequest getFirewallRuleGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallRuleGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallRuleGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallRuleGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFirewallRuleGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFirewallRuleGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFirewallRuleGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFirewallRuleGroupPolicyRequest, GetFirewallRuleGroupPolicyResponse>()
                            .withOperationName("GetFirewallRuleGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFirewallRuleGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFirewallRuleGroupPolicyRequest));
            CompletableFuture<GetFirewallRuleGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified Resolver on the Outpost, such as its instance count and type, name, and the
     * current status of the Resolver.
     * </p>
     *
     * @param getOutpostResolverRequest
     * @return A Java Future containing the result of the GetOutpostResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOutpostResolverResponse> getOutpostResolver(GetOutpostResolverRequest getOutpostResolverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOutpostResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOutpostResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOutpostResolver");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOutpostResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOutpostResolverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOutpostResolverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOutpostResolverRequest, GetOutpostResolverResponse>()
                            .withOperationName("GetOutpostResolver").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOutpostResolverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOutpostResolverRequest));
            CompletableFuture<GetOutpostResolverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     *
     * @param getResolverConfigRequest
     * @return A Java Future containing the result of the GetResolverConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverConfigResponse> getResolverConfig(GetResolverConfigRequest getResolverConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverConfigRequest, GetResolverConfigResponse>()
                            .withOperationName("GetResolverConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverConfigRequest));
            CompletableFuture<GetResolverConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets DNSSEC validation information for a specified resource.
     * </p>
     *
     * @param getResolverDnssecConfigRequest
     * @return A Java Future containing the result of the GetResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverDnssecConfigResponse> getResolverDnssecConfig(
            GetResolverDnssecConfigRequest getResolverDnssecConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverDnssecConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverDnssecConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverDnssecConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverDnssecConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverDnssecConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverDnssecConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverDnssecConfigRequest, GetResolverDnssecConfigResponse>()
                            .withOperationName("GetResolverDnssecConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverDnssecConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverDnssecConfigRequest));
            CompletableFuture<GetResolverDnssecConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver
     * endpoint, and the current status of the endpoint.
     * </p>
     *
     * @param getResolverEndpointRequest
     * @return A Java Future containing the result of the GetResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverEndpointResponse> getResolverEndpoint(
            GetResolverEndpointRequest getResolverEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverEndpointRequest, GetResolverEndpointResponse>()
                            .withOperationName("GetResolverEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverEndpointRequest));
            CompletableFuture<GetResolverEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the
     * configuration is logging queries for and the location that logs are sent to.
     * </p>
     *
     * @param getResolverQueryLogConfigRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverQueryLogConfigResponse> getResolverQueryLogConfig(
            GetResolverQueryLogConfigRequest getResolverQueryLogConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverQueryLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverQueryLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverQueryLogConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverQueryLogConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverQueryLogConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverQueryLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverQueryLogConfigRequest, GetResolverQueryLogConfigResponse>()
                            .withOperationName("GetResolverQueryLogConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverQueryLogConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverQueryLogConfigRequest));
            CompletableFuture<GetResolverQueryLogConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that
     * VPC.
     * </p>
     *
     * @param getResolverQueryLogConfigAssociationRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfigAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverQueryLogConfigAssociationResponse> getResolverQueryLogConfigAssociation(
            GetResolverQueryLogConfigAssociationRequest getResolverQueryLogConfigAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverQueryLogConfigAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getResolverQueryLogConfigAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverQueryLogConfigAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverQueryLogConfigAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetResolverQueryLogConfigAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverQueryLogConfigAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverQueryLogConfigAssociationRequest, GetResolverQueryLogConfigAssociationResponse>()
                            .withOperationName("GetResolverQueryLogConfigAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverQueryLogConfigAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverQueryLogConfigAssociationRequest));
            CompletableFuture<GetResolverQueryLogConfigAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
     * operations and resources that you want to allow another Amazon Web Services account to be able to use.
     * </p>
     *
     * @param getResolverQueryLogConfigPolicyRequest
     * @return A Java Future containing the result of the GetResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverQueryLogConfigPolicyResponse> getResolverQueryLogConfigPolicy(
            GetResolverQueryLogConfigPolicyRequest getResolverQueryLogConfigPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverQueryLogConfigPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getResolverQueryLogConfigPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverQueryLogConfigPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverQueryLogConfigPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverQueryLogConfigPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverQueryLogConfigPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverQueryLogConfigPolicyRequest, GetResolverQueryLogConfigPolicyResponse>()
                            .withOperationName("GetResolverQueryLogConfigPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverQueryLogConfigPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverQueryLogConfigPolicyRequest));
            CompletableFuture<GetResolverQueryLogConfigPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for
     * and the ID of the outbound Resolver endpoint that the rule is associated with.
     * </p>
     *
     * @param getResolverRuleRequest
     * @return A Java Future containing the result of the GetResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverRuleResponse> getResolverRule(GetResolverRuleRequest getResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverRuleRequest, GetResolverRuleResponse>()
                            .withOperationName("GetResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverRuleRequest));
            CompletableFuture<GetResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule
     * and a VPC using <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     * >AssociateResolverRule</a>.
     * </p>
     *
     * @param getResolverRuleAssociationRequest
     * @return A Java Future containing the result of the GetResolverRuleAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRuleAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverRuleAssociationResponse> getResolverRuleAssociation(
            GetResolverRuleAssociationRequest getResolverRuleAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverRuleAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverRuleAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverRuleAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverRuleAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverRuleAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverRuleAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverRuleAssociationRequest, GetResolverRuleAssociationResponse>()
                            .withOperationName("GetResolverRuleAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverRuleAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverRuleAssociationRequest));
            CompletableFuture<GetResolverRuleAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule
     * that you want to share with another account, the account that you want to share the rule with, and the Resolver
     * operations that you want to allow the account to use.
     * </p>
     *
     * @param getResolverRulePolicyRequest
     * @return A Java Future containing the result of the GetResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.GetResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResolverRulePolicyResponse> getResolverRulePolicy(
            GetResolverRulePolicyRequest getResolverRulePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverRulePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverRulePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolverRulePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResolverRulePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResolverRulePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResolverRulePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResolverRulePolicyRequest, GetResolverRulePolicyResponse>()
                            .withOperationName("GetResolverRulePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResolverRulePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResolverRulePolicyRequest));
            CompletableFuture<GetResolverRulePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     * </p>
     * <p>
     * Each domain specification in your domain list must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can optionally start with <code>*</code> (asterisk).
     * </p>
     * </li>
     * <li>
     * <p>
     * With the exception of the optional starting asterisk, it must only contain the following characters:
     * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
     * </p>
     * </li>
     * <li>
     * <p>
     * It must be from 1-255 characters in length.
     * </p>
     * </li>
     * </ul>
     *
     * @param importFirewallDomainsRequest
     * @return A Java Future containing the result of the ImportFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportFirewallDomainsResponse> importFirewallDomains(
            ImportFirewallDomainsRequest importFirewallDomainsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportFirewallDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportFirewallDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportFirewallDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportFirewallDomainsRequest, ImportFirewallDomainsResponse>()
                            .withOperationName("ImportFirewallDomains").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportFirewallDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importFirewallDomainsRequest));
            CompletableFuture<ImportFirewallDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage
     * firewall behavior for your VPCs.
     * </p>
     * <p>
     * A single call might return only a partial list of the configurations. For information, see
     * <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallConfigsRequest
     * @return A Java Future containing the result of the ListFirewallConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallConfigsResponse> listFirewallConfigs(
            ListFirewallConfigsRequest listFirewallConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallConfigsRequest, ListFirewallConfigsResponse>()
                            .withOperationName("ListFirewallConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallConfigsRequest));
            CompletableFuture<ListFirewallConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the
     * domains that are defined for a list by calling <a>ListFirewallDomains</a>.
     * </p>
     * <p>
     * A single call to this list operation might return only a partial list of the domain lists. For information, see
     * <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return A Java Future containing the result of the ListFirewallDomainLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallDomainListsResponse> listFirewallDomainLists(
            ListFirewallDomainListsRequest listFirewallDomainListsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallDomainListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallDomainListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallDomainLists");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallDomainListsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallDomainListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallDomainListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallDomainListsRequest, ListFirewallDomainListsResponse>()
                            .withOperationName("ListFirewallDomainLists").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallDomainListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallDomainListsRequest));
            CompletableFuture<ListFirewallDomainListsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the domains that you have defined for the specified firewall domain list.
     * </p>
     * <p>
     * A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return A Java Future containing the result of the ListFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallDomainsResponse> listFirewallDomains(
            ListFirewallDomainsRequest listFirewallDomainsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallDomainsRequest, ListFirewallDomainsResponse>()
                            .withOperationName("ListFirewallDomains").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallDomainsRequest));
            CompletableFuture<ListFirewallDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for
     * a VPC with one rule group.
     * </p>
     * <p>
     * A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRuleGroupAssociationsRequest
     * @return A Java Future containing the result of the ListFirewallRuleGroupAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallRuleGroupAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallRuleGroupAssociationsResponse> listFirewallRuleGroupAssociations(
            ListFirewallRuleGroupAssociationsRequest listFirewallRuleGroupAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallRuleGroupAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFirewallRuleGroupAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallRuleGroupAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallRuleGroupAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListFirewallRuleGroupAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallRuleGroupAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallRuleGroupAssociationsRequest, ListFirewallRuleGroupAssociationsResponse>()
                            .withOperationName("ListFirewallRuleGroupAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallRuleGroupAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallRuleGroupAssociationsRequest));
            CompletableFuture<ListFirewallRuleGroupAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     * </p>
     * <p>
     * A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRuleGroupsRequest
     * @return A Java Future containing the result of the ListFirewallRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallRuleGroupsResponse> listFirewallRuleGroups(
            ListFirewallRuleGroupsRequest listFirewallRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallRuleGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallRuleGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallRuleGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallRuleGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallRuleGroupsRequest, ListFirewallRuleGroupsResponse>()
                            .withOperationName("ListFirewallRuleGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallRuleGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallRuleGroupsRequest));
            CompletableFuture<ListFirewallRuleGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the
     * rules in a rule group to filter DNS network traffic for a VPC.
     * </p>
     * <p>
     * A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return A Java Future containing the result of the ListFirewallRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFirewallRulesResponse> listFirewallRules(ListFirewallRulesRequest listFirewallRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFirewallRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFirewallRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFirewallRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFirewallRulesRequest, ListFirewallRulesResponse>()
                            .withOperationName("ListFirewallRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFirewallRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFirewallRulesRequest));
            CompletableFuture<ListFirewallRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listOutpostResolversRequest
     * @return A Java Future containing the result of the ListOutpostResolvers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListOutpostResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOutpostResolversResponse> listOutpostResolvers(
            ListOutpostResolversRequest listOutpostResolversRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOutpostResolversRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOutpostResolversRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOutpostResolvers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOutpostResolversResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOutpostResolversResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOutpostResolversResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOutpostResolversRequest, ListOutpostResolversResponse>()
                            .withOperationName("ListOutpostResolvers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOutpostResolversRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOutpostResolversRequest));
            CompletableFuture<ListOutpostResolversResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage
     * DNS resolution behavior for your VPCs.
     * </p>
     *
     * @param listResolverConfigsRequest
     * @return A Java Future containing the result of the ListResolverConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverConfigsResponse> listResolverConfigs(
            ListResolverConfigsRequest listResolverConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverConfigsRequest, ListResolverConfigsResponse>()
                            .withOperationName("ListResolverConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverConfigsRequest));
            CompletableFuture<ListResolverConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     * @return A Java Future containing the result of the ListResolverDnssecConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverDnssecConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverDnssecConfigsResponse> listResolverDnssecConfigs(
            ListResolverDnssecConfigsRequest listResolverDnssecConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverDnssecConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverDnssecConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverDnssecConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverDnssecConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverDnssecConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverDnssecConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverDnssecConfigsRequest, ListResolverDnssecConfigsResponse>()
                            .withOperationName("ListResolverDnssecConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverDnssecConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverDnssecConfigsRequest));
            CompletableFuture<ListResolverDnssecConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     * @return A Java Future containing the result of the ListResolverEndpointIpAddresses operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpointIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverEndpointIpAddressesResponse> listResolverEndpointIpAddresses(
            ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverEndpointIpAddressesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResolverEndpointIpAddressesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverEndpointIpAddresses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverEndpointIpAddressesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverEndpointIpAddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverEndpointIpAddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverEndpointIpAddressesRequest, ListResolverEndpointIpAddressesResponse>()
                            .withOperationName("ListResolverEndpointIpAddresses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverEndpointIpAddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverEndpointIpAddressesRequest));
            CompletableFuture<ListResolverEndpointIpAddressesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverEndpointsRequest
     * @return A Java Future containing the result of the ListResolverEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverEndpointsResponse> listResolverEndpoints(
            ListResolverEndpointsRequest listResolverEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverEndpointsRequest, ListResolverEndpointsResponse>()
                            .withOperationName("ListResolverEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverEndpointsRequest));
            CompletableFuture<ListResolverEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     * @return A Java Future containing the result of the ListResolverQueryLogConfigAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> listResolverQueryLogConfigAssociations(
            ListResolverQueryLogConfigAssociationsRequest listResolverQueryLogConfigAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverQueryLogConfigAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResolverQueryLogConfigAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverQueryLogConfigAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverQueryLogConfigAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListResolverQueryLogConfigAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverQueryLogConfigAssociationsRequest, ListResolverQueryLogConfigAssociationsResponse>()
                            .withOperationName("ListResolverQueryLogConfigAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverQueryLogConfigAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverQueryLogConfigAssociationsRequest));
            CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     * @return A Java Future containing the result of the ListResolverQueryLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverQueryLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverQueryLogConfigsResponse> listResolverQueryLogConfigs(
            ListResolverQueryLogConfigsRequest listResolverQueryLogConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverQueryLogConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverQueryLogConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverQueryLogConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverQueryLogConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverQueryLogConfigsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverQueryLogConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverQueryLogConfigsRequest, ListResolverQueryLogConfigsResponse>()
                            .withOperationName("ListResolverQueryLogConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverQueryLogConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverQueryLogConfigsRequest));
            CompletableFuture<ListResolverQueryLogConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     * @return A Java Future containing the result of the ListResolverRuleAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRuleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverRuleAssociationsResponse> listResolverRuleAssociations(
            ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverRuleAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverRuleAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverRuleAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverRuleAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverRuleAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverRuleAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverRuleAssociationsRequest, ListResolverRuleAssociationsResponse>()
                            .withOperationName("ListResolverRuleAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverRuleAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverRuleAssociationsRequest));
            CompletableFuture<ListResolverRuleAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverRulesRequest
     * @return A Java Future containing the result of the ListResolverRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListResolverRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResolverRulesResponse> listResolverRules(ListResolverRulesRequest listResolverRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolverRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolverRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolverRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResolverRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResolverRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResolverRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResolverRulesRequest, ListResolverRulesResponse>()
                            .withOperationName("ListResolverRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResolverRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResolverRulesRequest));
            CompletableFuture<ListResolverRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidNextTokenException The value that you specified for <code>NextToken</code> in a
     *         <code>List</code> request isn't valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can
     * use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     *
     * @param putFirewallRuleGroupPolicyRequest
     * @return A Java Future containing the result of the PutFirewallRuleGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutFirewallRuleGroupPolicyResponse> putFirewallRuleGroupPolicy(
            PutFirewallRuleGroupPolicyRequest putFirewallRuleGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFirewallRuleGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFirewallRuleGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFirewallRuleGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFirewallRuleGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutFirewallRuleGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutFirewallRuleGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutFirewallRuleGroupPolicyRequest, PutFirewallRuleGroupPolicyResponse>()
                            .withOperationName("PutFirewallRuleGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutFirewallRuleGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putFirewallRuleGroupPolicyRequest));
            CompletableFuture<PutFirewallRuleGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query
     * logging configuration that you want to share, and the operations that you want the account to be able to perform
     * on the configuration.
     * </p>
     *
     * @param putResolverQueryLogConfigPolicyRequest
     * @return A Java Future containing the result of the PutResolverQueryLogConfigPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResolverQueryLogConfigPolicyResponse> putResolverQueryLogConfigPolicy(
            PutResolverQueryLogConfigPolicyRequest putResolverQueryLogConfigPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResolverQueryLogConfigPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putResolverQueryLogConfigPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResolverQueryLogConfigPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResolverQueryLogConfigPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResolverQueryLogConfigPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResolverQueryLogConfigPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResolverQueryLogConfigPolicyRequest, PutResolverQueryLogConfigPolicyResponse>()
                            .withOperationName("PutResolverQueryLogConfigPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResolverQueryLogConfigPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResolverQueryLogConfigPolicyRequest));
            CompletableFuture<PutResolverQueryLogConfigPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to
     * share the rule with, and the operations that you want the account to be able to perform on the rule.
     * </p>
     *
     * @param putResolverRulePolicyRequest
     * @return A Java Future containing the result of the PutResolverRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyDocumentException The specified Resolver rule policy is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>UnknownResourceException The specified resource doesn't exist.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.PutResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResolverRulePolicyResponse> putResolverRulePolicy(
            PutResolverRulePolicyRequest putResolverRulePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResolverRulePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResolverRulePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResolverRulePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResolverRulePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResolverRulePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResolverRulePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResolverRulePolicyRequest, PutResolverRulePolicyResponse>()
                            .withOperationName("PutResolverRulePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResolverRulePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResolverRulePolicyRequest));
            CompletableFuture<PutResolverRulePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidTagException The specified tag is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual
     * Private Cloud (Amazon VPC).
     * </p>
     *
     * @param updateFirewallConfigRequest
     * @return A Java Future containing the result of the UpdateFirewallConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallConfigResponse> updateFirewallConfig(
            UpdateFirewallConfigRequest updateFirewallConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFirewallConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallConfigRequest, UpdateFirewallConfigResponse>()
                            .withOperationName("UpdateFirewallConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallConfigRequest));
            CompletableFuture<UpdateFirewallConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the firewall domain list from an array of domain specifications.
     * </p>
     *
     * @param updateFirewallDomainsRequest
     * @return A Java Future containing the result of the UpdateFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallDomainsResponse> updateFirewallDomains(
            UpdateFirewallDomainsRequest updateFirewallDomainsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFirewallDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallDomainsRequest, UpdateFirewallDomainsResponse>()
                            .withOperationName("UpdateFirewallDomains").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallDomainsRequest));
            CompletableFuture<UpdateFirewallDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified firewall rule.
     * </p>
     *
     * @param updateFirewallRuleRequest
     * @return A Java Future containing the result of the UpdateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallRuleResponse> updateFirewallRule(UpdateFirewallRuleRequest updateFirewallRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFirewallRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFirewallRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallRuleRequest, UpdateFirewallRuleResponse>()
                            .withOperationName("UpdateFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallRuleRequest));
            CompletableFuture<UpdateFirewallRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the association of a <a>FirewallRuleGroup</a> with a VPC. The association enables DNS filtering for the
     * VPC.
     * </p>
     *
     * @param updateFirewallRuleGroupAssociationRequest
     * @return A Java Future containing the result of the UpdateFirewallRuleGroupAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateFirewallRuleGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFirewallRuleGroupAssociationResponse> updateFirewallRuleGroupAssociation(
            UpdateFirewallRuleGroupAssociationRequest updateFirewallRuleGroupAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallRuleGroupAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallRuleGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallRuleGroupAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFirewallRuleGroupAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateFirewallRuleGroupAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFirewallRuleGroupAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallRuleGroupAssociationRequest, UpdateFirewallRuleGroupAssociationResponse>()
                            .withOperationName("UpdateFirewallRuleGroupAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFirewallRuleGroupAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFirewallRuleGroupAssociationRequest));
            CompletableFuture<UpdateFirewallRuleGroupAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You can use <code>UpdateOutpostResolver</code> to update the instance count, type, or name of a Resolver on an
     * Outpost.
     * </p>
     *
     * @param updateOutpostResolverRequest
     * @return A Java Future containing the result of the UpdateOutpostResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ConflictException The requested state transition isn't valid. For example, you can't delete a
     *         firewall domain list if it is in the process of being deleted, or you can't import domains into a domain
     *         list that is in the process of being deleted.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Fulfilling the request would cause one or more quotas to be exceeded.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOutpostResolverResponse> updateOutpostResolver(
            UpdateOutpostResolverRequest updateOutpostResolverRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOutpostResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOutpostResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOutpostResolver");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOutpostResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOutpostResolverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOutpostResolverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOutpostResolverRequest, UpdateOutpostResolverResponse>()
                            .withOperationName("UpdateOutpostResolver").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOutpostResolverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOutpostResolverRequest));
            CompletableFuture<UpdateOutpostResolverResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     *
     * @param updateResolverConfigRequest
     * @return A Java Future containing the result of the UpdateResolverConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>ValidationException You have provided an invalid command. If you ran the
     *         <code>UpdateFirewallDomains</code> request. supported values are <code>ADD</code>, <code>REMOVE</code>,
     *         or <code>REPLACE</code> a domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResolverConfigResponse> updateResolverConfig(
            UpdateResolverConfigRequest updateResolverConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResolverConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResolverConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResolverConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResolverConfigRequest, UpdateResolverConfigResponse>()
                            .withOperationName("UpdateResolverConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResolverConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResolverConfigRequest));
            CompletableFuture<UpdateResolverConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one
     * is created.
     * </p>
     *
     * @param updateResolverDnssecConfigRequest
     * @return A Java Future containing the result of the UpdateResolverDnssecConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResolverDnssecConfigResponse> updateResolverDnssecConfig(
            UpdateResolverDnssecConfigRequest updateResolverDnssecConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverDnssecConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverDnssecConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverDnssecConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResolverDnssecConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResolverDnssecConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResolverDnssecConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResolverDnssecConfigRequest, UpdateResolverDnssecConfigResponse>()
                            .withOperationName("UpdateResolverDnssecConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResolverDnssecConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResolverDnssecConfigRequest));
            CompletableFuture<UpdateResolverDnssecConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name, or endpoint type for an inbound or an outbound Resolver endpoint. You can only update between
     * IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
     * </p>
     *
     * @param updateResolverEndpointRequest
     * @return A Java Future containing the result of the UpdateResolverEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResolverEndpointResponse> updateResolverEndpoint(
            UpdateResolverEndpointRequest updateResolverEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResolverEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResolverEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResolverEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse>()
                            .withOperationName("UpdateResolverEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResolverEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResolverEndpointRequest));
            CompletableFuture<UpdateResolverEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters
     * are optional. If you don't specify a parameter, it retains its current value.
     * </p>
     *
     * @param updateResolverRuleRequest
     * @return A Java Future containing the result of the UpdateResolverRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>InvalidParameterException One or more parameters in this request are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ResourceUnavailableException The specified resource isn't available.</li>
     *         <li>LimitExceededException The request caused one or more limits to be exceeded.</li>
     *         <li>InternalServiceErrorException We encountered an unknown error. Try again in a few minutes.</li>
     *         <li>ThrottlingException The request was throttled. Try again in a few minutes.</li>
     *         <li>AccessDeniedException The current account doesn't have the IAM permissions required to perform the
     *         specified Resolver operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53ResolverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53ResolverAsyncClient.UpdateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResolverRuleResponse> updateResolverRule(UpdateResolverRuleRequest updateResolverRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53Resolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResolverRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResolverRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResolverRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResolverRuleRequest, UpdateResolverRuleResponse>()
                            .withOperationName("UpdateResolverRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResolverRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResolverRuleRequest));
            CompletableFuture<UpdateResolverRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final Route53ResolverServiceClientConfiguration serviceClientConfiguration() {
        return new Route53ResolverServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Route53ResolverException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyDocument")
                                .exceptionBuilderSupplier(InvalidPolicyDocumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceErrorException")
                                .exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceExistsException")
                                .exceptionBuilderSupplier(ResourceExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagException")
                                .exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnknownResourceException")
                                .exceptionBuilderSupplier(UnknownResourceException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        Route53ResolverServiceClientConfigurationBuilder serviceConfigBuilder = new Route53ResolverServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
