/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.route53resolver.auth.scheme.Route53ResolverAuthSchemeProvider;
import software.amazon.awssdk.services.route53resolver.endpoints.Route53ResolverEndpointProvider;

/**
 * This includes configuration specific to Route53Resolver that is supported by both
 * {@link Route53ResolverClientBuilder} and {@link Route53ResolverAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface Route53ResolverBaseClientBuilder<B extends Route53ResolverBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
    /**
     * Set the {@link Route53ResolverEndpointProvider} implementation that will be used by the client to determine the
     * endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(Route53ResolverEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link Route53ResolverAuthSchemeProvider} implementation that will be used by the client to resolve the
     * auth scheme for each request. This is optional; if none is provided a default implementation will be used the
     * SDK.
     */
    default B authSchemeProvider(Route53ResolverAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
