/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportFirewallDomainsRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<ImportFirewallDomainsRequest.Builder, ImportFirewallDomainsRequest> {
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallDomainListId").getter(getter(ImportFirewallDomainsRequest::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build())
            .build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(ImportFirewallDomainsRequest::operationAsString))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> DOMAIN_FILE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainFileUrl").getter(getter(ImportFirewallDomainsRequest::domainFileUrl))
            .setter(setter(Builder::domainFileUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainFileUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_DOMAIN_LIST_ID_FIELD,
            OPERATION_FIELD, DOMAIN_FILE_URL_FIELD));

    private final String firewallDomainListId;

    private final String operation;

    private final String domainFileUrl;

    private ImportFirewallDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallDomainListId = builder.firewallDomainListId;
        this.operation = builder.operation;
        this.domainFileUrl = builder.domainFileUrl;
    }

    /**
     * <p>
     * The ID of the domain list that you want to modify with the import operation.
     * </p>
     * 
     * @return The ID of the domain list that you want to modify with the import operation.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
     * <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FirewallDomainImportOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
     *         <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
     * @see FirewallDomainImportOperation
     */
    public final FirewallDomainImportOperation operation() {
        return FirewallDomainImportOperation.fromValue(operation);
    }

    /**
     * <p>
     * What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
     * <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FirewallDomainImportOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
     *         <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
     * @see FirewallDomainImportOperation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the
     * list of domains to import.
     * </p>
     * <p>
     * The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file and
     * must contain a single domain per line.
     * </p>
     * 
     * @return The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that
     *         contains the list of domains to import.</p>
     *         <p>
     *         The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text
     *         file and must contain a single domain per line.
     */
    public final String domainFileUrl() {
        return domainFileUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainFileUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportFirewallDomainsRequest)) {
            return false;
        }
        ImportFirewallDomainsRequest other = (ImportFirewallDomainsRequest) obj;
        return Objects.equals(firewallDomainListId(), other.firewallDomainListId())
                && Objects.equals(operationAsString(), other.operationAsString())
                && Objects.equals(domainFileUrl(), other.domainFileUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportFirewallDomainsRequest").add("FirewallDomainListId", firewallDomainListId())
                .add("Operation", operationAsString()).add("DomainFileUrl", domainFileUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "DomainFileUrl":
            return Optional.ofNullable(clazz.cast(domainFileUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportFirewallDomainsRequest, T> g) {
        return obj -> g.apply((ImportFirewallDomainsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportFirewallDomainsRequest> {
        /**
         * <p>
         * The ID of the domain list that you want to modify with the import operation.
         * </p>
         * 
         * @param firewallDomainListId
         *        The ID of the domain list that you want to modify with the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
         * <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
         * </p>
         * 
         * @param operation
         *        What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
         *        <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
         * @see FirewallDomainImportOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainImportOperation
         */
        Builder operation(String operation);

        /**
         * <p>
         * What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
         * <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
         * </p>
         * 
         * @param operation
         *        What you want DNS Firewall to do with the domains that are listed in the file. This must be set to
         *        <code>REPLACE</code>, which updates the domain list to exactly match the list in the file.
         * @see FirewallDomainImportOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainImportOperation
         */
        Builder operation(FirewallDomainImportOperation operation);

        /**
         * <p>
         * The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains
         * the list of domains to import.
         * </p>
         * <p>
         * The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file
         * and must contain a single domain per line.
         * </p>
         * 
         * @param domainFileUrl
         *        The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that
         *        contains the list of domains to import.</p>
         *        <p>
         *        The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a
         *        text file and must contain a single domain per line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainFileUrl(String domainFileUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallDomainListId;

        private String operation;

        private String domainFileUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportFirewallDomainsRequest model) {
            super(model);
            firewallDomainListId(model.firewallDomainListId);
            operation(model.operation);
            domainFileUrl(model.domainFileUrl);
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FirewallDomainImportOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getDomainFileUrl() {
            return domainFileUrl;
        }

        public final void setDomainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
        }

        @Override
        public final Builder domainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportFirewallDomainsRequest build() {
            return new ImportFirewallDomainsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
