/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a configuration for DNSSEC validation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverDnssecConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverDnssecConfig.Builder, ResolverDnssecConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResolverDnssecConfig::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(ResolverDnssecConfig::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResolverDnssecConfig::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatus").getter(getter(ResolverDnssecConfig::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, OWNER_ID_FIELD,
            RESOURCE_ID_FIELD, VALIDATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String ownerId;

    private final String resourceId;

    private final String validationStatus;

    private ResolverDnssecConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.ownerId = builder.ownerId;
        this.resourceId = builder.resourceId;
        this.validationStatus = builder.validationStatus;
    }

    /**
     * <p>
     * The ID for a configuration for DNSSEC validation.
     * </p>
     * 
     * @return The ID for a configuration for DNSSEC validation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
     * </p>
     * 
     * @return The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The validation status for a DNSSEC configuration. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ENABLED:</b> DNSSEC validation is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLED</b> DNSSEC validation is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link ResolverDNSSECValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status for a DNSSEC configuration. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ENABLED:</b> DNSSEC validation is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLED</b> DNSSEC validation is disabled.
     *         </p>
     *         </li>
     * @see ResolverDNSSECValidationStatus
     */
    public final ResolverDNSSECValidationStatus validationStatus() {
        return ResolverDNSSECValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The validation status for a DNSSEC configuration. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ENABLED:</b> DNSSEC validation is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLED</b> DNSSEC validation is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link ResolverDNSSECValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status for a DNSSEC configuration. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ENABLED:</b> DNSSEC validation is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLED</b> DNSSEC validation is disabled.
     *         </p>
     *         </li>
     * @see ResolverDNSSECValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverDnssecConfig)) {
            return false;
        }
        ResolverDnssecConfig other = (ResolverDnssecConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolverDnssecConfig").add("Id", id()).add("OwnerId", ownerId()).add("ResourceId", resourceId())
                .add("ValidationStatus", validationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ValidationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverDnssecConfig, T> g) {
        return obj -> g.apply((ResolverDnssecConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverDnssecConfig> {
        /**
         * <p>
         * The ID for a configuration for DNSSEC validation.
         * </p>
         * 
         * @param id
         *        The ID for a configuration for DNSSEC validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
         * </p>
         * 
         * @param ownerId
         *        The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
         * </p>
         * 
         * @param resourceId
         *        The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The validation status for a DNSSEC configuration. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ENABLED:</b> DNSSEC validation is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED</b> DNSSEC validation is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationStatus
         *        The validation status for a DNSSEC configuration. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ENABLED:</b> DNSSEC validation is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLED</b> DNSSEC validation is disabled.
         *        </p>
         *        </li>
         * @see ResolverDNSSECValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverDNSSECValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The validation status for a DNSSEC configuration. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ENABLED:</b> DNSSEC validation is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED</b> DNSSEC validation is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationStatus
         *        The validation status for a DNSSEC configuration. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ENABLED:</b> DNSSEC validation is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLED</b> DNSSEC validation is disabled.
         *        </p>
         *        </li>
         * @see ResolverDNSSECValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverDNSSECValidationStatus
         */
        Builder validationStatus(ResolverDNSSECValidationStatus validationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String ownerId;

        private String resourceId;

        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverDnssecConfig model) {
            id(model.id);
            ownerId(model.ownerId);
            resourceId(model.resourceId);
            validationStatus(model.validationStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(ResolverDNSSECValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        @Override
        public ResolverDnssecConfig build() {
            return new ResolverDnssecConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
