/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">
 * CreateResolverRule</a> request, an array of the IPs that you want to forward DNS queries to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetAddress implements SdkPojo, Serializable, ToCopyableBuilder<TargetAddress.Builder, TargetAddress> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(TargetAddress::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(TargetAddress::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ipv6")
            .getter(getter(TargetAddress::ipv6)).setter(setter(Builder::ipv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(TargetAddress::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD,
            IPV6_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ip;

    private final Integer port;

    private final String ipv6;

    private final String protocol;

    private TargetAddress(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.ipv6 = builder.ipv6;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * One IPv4 address that you want to forward DNS queries to.
     * </p>
     * 
     * @return One IPv4 address that you want to forward DNS queries to.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The port at <code>Ip</code> that you want to forward DNS queries to.
     * </p>
     * 
     * @return The port at <code>Ip</code> that you want to forward DNS queries to.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * One IPv6 address that you want to forward DNS queries to.
     * </p>
     * 
     * @return One IPv6 address that you want to forward DNS queries to.
     */
    public final String ipv6() {
        return ipv6;
    }

    /**
     * <p>
     * The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only.
     * </p>
     * <p>
     * For an inbound endpoint you can apply the protocols as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do53 and DoH in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 and DoH-FIPS in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH-FIPS alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * None, which is treated as Do53.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an outbound endpoint you can apply the protocols as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do53 and DoH in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * None, which is treated as Do53.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only. </p>
     *         <p>
     *         For an inbound endpoint you can apply the protocols as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Do53 and DoH in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 and DoH-FIPS in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH-FIPS alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None, which is treated as Do53.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For an outbound endpoint you can apply the protocols as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Do53 and DoH in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None, which is treated as Do53.
     *         </p>
     *         </li>
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only.
     * </p>
     * <p>
     * For an inbound endpoint you can apply the protocols as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do53 and DoH in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 and DoH-FIPS in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH-FIPS alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * None, which is treated as Do53.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an outbound endpoint you can apply the protocols as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do53 and DoH in combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do53 alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * DoH alone.
     * </p>
     * </li>
     * <li>
     * <p>
     * None, which is treated as Do53.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only. </p>
     *         <p>
     *         For an inbound endpoint you can apply the protocols as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Do53 and DoH in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 and DoH-FIPS in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH-FIPS alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None, which is treated as Do53.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For an outbound endpoint you can apply the protocols as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Do53 and DoH in combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do53 alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DoH alone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         None, which is treated as Do53.
     *         </p>
     *         </li>
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAddress)) {
            return false;
        }
        TargetAddress other = (TargetAddress) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(port(), other.port()) && Objects.equals(ipv6(), other.ipv6())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetAddress").add("Ip", ip()).add("Port", port()).add("Ipv6", ipv6())
                .add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Ipv6":
            return Optional.ofNullable(clazz.cast(ipv6()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetAddress, T> g) {
        return obj -> g.apply((TargetAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetAddress> {
        /**
         * <p>
         * One IPv4 address that you want to forward DNS queries to.
         * </p>
         * 
         * @param ip
         *        One IPv4 address that you want to forward DNS queries to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The port at <code>Ip</code> that you want to forward DNS queries to.
         * </p>
         * 
         * @param port
         *        The port at <code>Ip</code> that you want to forward DNS queries to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * One IPv6 address that you want to forward DNS queries to.
         * </p>
         * 
         * @param ipv6
         *        One IPv6 address that you want to forward DNS queries to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6(String ipv6);

        /**
         * <p>
         * The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only.
         * </p>
         * <p>
         * For an inbound endpoint you can apply the protocols as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do53 and DoH in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 and DoH-FIPS in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH-FIPS alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * None, which is treated as Do53.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For an outbound endpoint you can apply the protocols as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do53 and DoH in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * None, which is treated as Do53.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only. </p>
         *        <p>
         *        For an inbound endpoint you can apply the protocols as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do53 and DoH in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 and DoH-FIPS in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH-FIPS alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None, which is treated as Do53.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For an outbound endpoint you can apply the protocols as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do53 and DoH in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None, which is treated as Do53.
         *        </p>
         *        </li>
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only.
         * </p>
         * <p>
         * For an inbound endpoint you can apply the protocols as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do53 and DoH in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 and DoH-FIPS in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH-FIPS alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * None, which is treated as Do53.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For an outbound endpoint you can apply the protocols as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do53 and DoH in combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do53 alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * DoH alone.
         * </p>
         * </li>
         * <li>
         * <p>
         * None, which is treated as Do53.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocols for the Resolver endpoints. DoH-FIPS is applicable for inbound endpoints only. </p>
         *        <p>
         *        For an inbound endpoint you can apply the protocols as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do53 and DoH in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 and DoH-FIPS in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH-FIPS alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None, which is treated as Do53.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For an outbound endpoint you can apply the protocols as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do53 and DoH in combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do53 alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DoH alone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        None, which is treated as Do53.
         *        </p>
         *        </li>
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private Integer port;

        private String ipv6;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetAddress model) {
            ip(model.ip);
            port(model.port);
            ipv6(model.ipv6);
            protocol(model.protocol);
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getIpv6() {
            return ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public TargetAddress build() {
            return new TargetAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
