/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutpostResolverResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetOutpostResolverResponse.Builder, GetOutpostResolverResponse> {
    private static final SdkField<OutpostResolver> OUTPOST_RESOLVER_FIELD = SdkField
            .<OutpostResolver> builder(MarshallingType.SDK_POJO).memberName("OutpostResolver")
            .getter(getter(GetOutpostResolverResponse::outpostResolver)).setter(setter(Builder::outpostResolver))
            .constructor(OutpostResolver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostResolver").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_RESOLVER_FIELD));

    private final OutpostResolver outpostResolver;

    private GetOutpostResolverResponse(BuilderImpl builder) {
        super(builder);
        this.outpostResolver = builder.outpostResolver;
    }

    /**
     * <p>
     * Information about the <code>GetOutpostResolver</code> request, including the status of the request.
     * </p>
     * 
     * @return Information about the <code>GetOutpostResolver</code> request, including the status of the request.
     */
    public final OutpostResolver outpostResolver() {
        return outpostResolver;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostResolver());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostResolverResponse)) {
            return false;
        }
        GetOutpostResolverResponse other = (GetOutpostResolverResponse) obj;
        return Objects.equals(outpostResolver(), other.outpostResolver());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOutpostResolverResponse").add("OutpostResolver", outpostResolver()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostResolver":
            return Optional.ofNullable(clazz.cast(outpostResolver()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostResolverResponse, T> g) {
        return obj -> g.apply((GetOutpostResolverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOutpostResolverResponse> {
        /**
         * <p>
         * Information about the <code>GetOutpostResolver</code> request, including the status of the request.
         * </p>
         * 
         * @param outpostResolver
         *        Information about the <code>GetOutpostResolver</code> request, including the status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostResolver(OutpostResolver outpostResolver);

        /**
         * <p>
         * Information about the <code>GetOutpostResolver</code> request, including the status of the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutpostResolver.Builder} avoiding the
         * need to create one manually via {@link OutpostResolver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutpostResolver.Builder#build()} is called immediately and its
         * result is passed to {@link #outpostResolver(OutpostResolver)}.
         * 
         * @param outpostResolver
         *        a consumer that will call methods on {@link OutpostResolver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outpostResolver(OutpostResolver)
         */
        default Builder outpostResolver(Consumer<OutpostResolver.Builder> outpostResolver) {
            return outpostResolver(OutpostResolver.builder().applyMutation(outpostResolver).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private OutpostResolver outpostResolver;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostResolverResponse model) {
            super(model);
            outpostResolver(model.outpostResolver);
        }

        public final OutpostResolver.Builder getOutpostResolver() {
            return outpostResolver != null ? outpostResolver.toBuilder() : null;
        }

        public final void setOutpostResolver(OutpostResolver.BuilderImpl outpostResolver) {
            this.outpostResolver = outpostResolver != null ? outpostResolver.build() : null;
        }

        @Override
        public final Builder outpostResolver(OutpostResolver outpostResolver) {
            this.outpostResolver = outpostResolver;
            return this;
        }

        @Override
        public GetOutpostResolverResponse build() {
            return new GetOutpostResolverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
