/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallRuleRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<DeleteFirewallRuleRequest.Builder, DeleteFirewallRuleRequest> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(DeleteFirewallRuleRequest::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallDomainListId").getter(getter(DeleteFirewallRuleRequest::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build())
            .build();

    private static final SdkField<String> QTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Qtype")
            .getter(getter(DeleteFirewallRuleRequest::qtype)).setter(setter(Builder::qtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qtype").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ID_FIELD,
            FIREWALL_DOMAIN_LIST_ID_FIELD, QTYPE_FIELD));

    private final String firewallRuleGroupId;

    private final String firewallDomainListId;

    private final String qtype;

    private DeleteFirewallRuleRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.qtype = builder.qtype;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group that you want to delete the rule from.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group that you want to delete the rule from.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * The ID of the domain list that's used in the rule.
     * </p>
     * 
     * @return The ID of the domain list that's used in the rule.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * The DNS query type that the rule you are deleting evaluates. Allowed values are;
     * </p>
     * <ul>
     * <li>
     * <p>
     * A: Returns an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * AAAA: Returns an Ipv6 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * CNAME: Returns another domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * DS: Record that identifies the DNSSEC signing key of a delegated zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * MX: Specifies mail servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * NAPTR: Regular-expression-based rewriting of domain names.
     * </p>
     * </li>
     * <li>
     * <p>
     * NS: Authoritative name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * PTR: Maps an IP address to a domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * SOA: Start of authority record for the zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * SPF: Lists the servers authorized to send emails from a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * SRV: Application specific values that identify servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * TXT: Verifies email senders and application-specific values.
     * </p>
     * </li>
     * <li>
     * <p>
     * A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as
     * TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a
     * href="https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The DNS query type that the rule you are deleting evaluates. Allowed values are; </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A: Returns an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AAAA: Returns an Ipv6 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CNAME: Returns another domain name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DS: Record that identifies the DNSSEC signing key of a delegated zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MX: Specifies mail servers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NAPTR: Regular-expression-based rewriting of domain names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NS: Authoritative name servers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PTR: Maps an IP address to a domain name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SOA: Start of authority record for the zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SPF: Lists the servers authorized to send emails from a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SRV: Application specific values that identify servers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TXT: Verifies email senders and application-specific values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as
     *         TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a
     *         href="https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a>.
     *         </p>
     *         </li>
     */
    public final String qtype() {
        return qtype;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(qtype());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallRuleRequest)) {
            return false;
        }
        DeleteFirewallRuleRequest other = (DeleteFirewallRuleRequest) obj;
        return Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId())
                && Objects.equals(firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(qtype(), other.qtype());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallRuleRequest").add("FirewallRuleGroupId", firewallRuleGroupId())
                .add("FirewallDomainListId", firewallDomainListId()).add("Qtype", qtype()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "FirewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "Qtype":
            return Optional.ofNullable(clazz.cast(qtype()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallRuleRequest, T> g) {
        return obj -> g.apply((DeleteFirewallRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFirewallRuleRequest> {
        /**
         * <p>
         * The unique identifier of the firewall rule group that you want to delete the rule from.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group that you want to delete the rule from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * The ID of the domain list that's used in the rule.
         * </p>
         * 
         * @param firewallDomainListId
         *        The ID of the domain list that's used in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * The DNS query type that the rule you are deleting evaluates. Allowed values are;
         * </p>
         * <ul>
         * <li>
         * <p>
         * A: Returns an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * AAAA: Returns an Ipv6 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * CNAME: Returns another domain name.
         * </p>
         * </li>
         * <li>
         * <p>
         * DS: Record that identifies the DNSSEC signing key of a delegated zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * MX: Specifies mail servers.
         * </p>
         * </li>
         * <li>
         * <p>
         * NAPTR: Regular-expression-based rewriting of domain names.
         * </p>
         * </li>
         * <li>
         * <p>
         * NS: Authoritative name servers.
         * </p>
         * </li>
         * <li>
         * <p>
         * PTR: Maps an IP address to a domain name.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOA: Start of authority record for the zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * SPF: Lists the servers authorized to send emails from a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * SRV: Application specific values that identify servers.
         * </p>
         * </li>
         * <li>
         * <p>
         * TXT: Verifies email senders and application-specific values.
         * </p>
         * </li>
         * <li>
         * <p>
         * A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined as
         * TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a
         * href="https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param qtype
         *        The DNS query type that the rule you are deleting evaluates. Allowed values are; </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A: Returns an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AAAA: Returns an Ipv6 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CNAME: Returns another domain name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DS: Record that identifies the DNSSEC signing key of a delegated zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MX: Specifies mail servers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NAPTR: Regular-expression-based rewriting of domain names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NS: Authoritative name servers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PTR: Maps an IP address to a domain name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOA: Start of authority record for the zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SPF: Lists the servers authorized to send emails from a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SRV: Application specific values that identify servers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TXT: Verifies email senders and application-specific values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A query type you define by using the DNS type ID, for example 28 for AAAA. The values must be defined
         *        as TYPENUMBER, where the NUMBER can be 1-65334, for example, TYPE28. For more information, see <a
         *        href="https://en.wikipedia.org/wiki/List_of_DNS_record_types">List of DNS record types</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qtype(String qtype);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallRuleGroupId;

        private String firewallDomainListId;

        private String qtype;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallRuleRequest model) {
            super(model);
            firewallRuleGroupId(model.firewallRuleGroupId);
            firewallDomainListId(model.firewallDomainListId);
            qtype(model.qtype);
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getQtype() {
            return qtype;
        }

        public final void setQtype(String qtype) {
            this.qtype = qtype;
        }

        @Override
        public final Builder qtype(String qtype) {
            this.qtype = qtype;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFirewallRuleRequest build() {
            return new DeleteFirewallRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
