/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.IpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.IpAddressesResponseCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverEndpointIpAddressesResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverEndpointIpAddressesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverEndpointIpAddressesResponse.getter(ListResolverEndpointIpAddressesResponse::nextToken)).setter(ListResolverEndpointIpAddressesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResolverEndpointIpAddressesResponse.getter(ListResolverEndpointIpAddressesResponse::maxResults)).setter(ListResolverEndpointIpAddressesResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<IpAddressResponse>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpAddresses").getter(ListResolverEndpointIpAddressesResponse.getter(ListResolverEndpointIpAddressesResponse::ipAddresses)).setter(ListResolverEndpointIpAddressesResponse.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpAddressResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, IP_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("IpAddresses", IP_ADDRESSES_FIELD);
        }
    });
    private final String nextToken;
    private final Integer maxResults;
    private final List<IpAddressResponse> ipAddresses;

    private ListResolverEndpointIpAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.ipAddresses = builder.ipAddresses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public final List<IpAddressResponse> ipAddresses() {
        return this.ipAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpAddresses() ? this.ipAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverEndpointIpAddressesResponse)) {
            return false;
        }
        ListResolverEndpointIpAddressesResponse other = (ListResolverEndpointIpAddressesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasIpAddresses() == other.hasIpAddresses() && Objects.equals(this.ipAddresses(), other.ipAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverEndpointIpAddressesResponse").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("IpAddresses", this.hasIpAddresses() ? this.ipAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverEndpointIpAddressesResponse, T> g) {
        return obj -> g.apply((ListResolverEndpointIpAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<IpAddressResponse> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverEndpointIpAddressesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.ipAddresses(model.ipAddresses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<IpAddressResponse.Builder> getIpAddresses() {
            List<IpAddressResponse.Builder> result = IpAddressesResponseCopier.copyToBuilder(this.ipAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpAddresses(Collection<IpAddressResponse.BuilderImpl> ipAddresses) {
            this.ipAddresses = IpAddressesResponseCopier.copyFromBuilder(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<IpAddressResponse> ipAddresses) {
            this.ipAddresses = IpAddressesResponseCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(IpAddressResponse ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(Consumer<IpAddressResponse.Builder> ... ipAddresses) {
            this.ipAddresses(Stream.of(ipAddresses).map(c -> (IpAddressResponse)((IpAddressResponse.Builder)IpAddressResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResolverEndpointIpAddressesResponse build() {
            return new ListResolverEndpointIpAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverEndpointIpAddressesResponse> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder ipAddresses(Collection<IpAddressResponse> var1);

        public Builder ipAddresses(IpAddressResponse ... var1);

        public Builder ipAddresses(Consumer<IpAddressResponse.Builder> ... var1);
    }
}

