/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateResolverQueryLogConfigRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<AssociateResolverQueryLogConfigRequest.Builder, AssociateResolverQueryLogConfigRequest> {
    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverQueryLogConfigId")
            .getter(getter(AssociateResolverQueryLogConfigRequest::resolverQueryLogConfigId))
            .setter(setter(Builder::resolverQueryLogConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigId").build())
            .build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(AssociateResolverQueryLogConfigRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOLVER_QUERY_LOG_CONFIG_ID_FIELD, RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resolverQueryLogConfigId;

    private final String resourceId;

    private AssociateResolverQueryLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resolverQueryLogConfigId = builder.resolverQueryLogConfigId;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The ID of the query logging configuration that you want to associate a VPC with.
     * </p>
     * 
     * @return The ID of the query logging configuration that you want to associate a VPC with.
     */
    public final String resolverQueryLogConfigId() {
        return resolverQueryLogConfigId;
    }

    /**
     * <p>
     * The ID of an Amazon VPC that you want this query logging configuration to log queries for.
     * </p>
     * <note>
     * <p>
     * The VPCs and the query logging configuration must be in the same Region.
     * </p>
     * </note>
     * 
     * @return The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note>
     *         <p>
     *         The VPCs and the query logging configuration must be in the same Region.
     *         </p>
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverQueryLogConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResolverQueryLogConfigRequest)) {
            return false;
        }
        AssociateResolverQueryLogConfigRequest other = (AssociateResolverQueryLogConfigRequest) obj;
        return Objects.equals(resolverQueryLogConfigId(), other.resolverQueryLogConfigId())
                && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateResolverQueryLogConfigRequest")
                .add("ResolverQueryLogConfigId", resolverQueryLogConfigId()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverQueryLogConfigId":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResolverQueryLogConfigId", RESOLVER_QUERY_LOG_CONFIG_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateResolverQueryLogConfigRequest, T> g) {
        return obj -> g.apply((AssociateResolverQueryLogConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateResolverQueryLogConfigRequest> {
        /**
         * <p>
         * The ID of the query logging configuration that you want to associate a VPC with.
         * </p>
         * 
         * @param resolverQueryLogConfigId
         *        The ID of the query logging configuration that you want to associate a VPC with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigId(String resolverQueryLogConfigId);

        /**
         * <p>
         * The ID of an Amazon VPC that you want this query logging configuration to log queries for.
         * </p>
         * <note>
         * <p>
         * The VPCs and the query logging configuration must be in the same Region.
         * </p>
         * </note>
         * 
         * @param resourceId
         *        The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note>
         *        <p>
         *        The VPCs and the query logging configuration must be in the same Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverQueryLogConfigId;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResolverQueryLogConfigRequest model) {
            super(model);
            resolverQueryLogConfigId(model.resolverQueryLogConfigId);
            resourceId(model.resourceId);
        }

        public final String getResolverQueryLogConfigId() {
            return resolverQueryLogConfigId;
        }

        public final void setResolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
        }

        @Override
        public final Builder resolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResolverQueryLogConfigRequest build() {
            return new AssociateResolverQueryLogConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
