/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In an <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html"
 * >UpdateResolverEndpoint</a> request, information about an IP address to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddressUpdate implements SdkPojo, Serializable, ToCopyableBuilder<IpAddressUpdate.Builder, IpAddressUpdate> {
    private static final SdkField<String> IP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("IpId")
            .getter(getter(IpAddressUpdate::ipId)).setter(setter(Builder::ipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(IpAddressUpdate::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(IpAddressUpdate::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<String> IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ipv6")
            .getter(getter(IpAddressUpdate::ipv6)).setter(setter(Builder::ipv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ID_FIELD, SUBNET_ID_FIELD,
            IP_FIELD, IPV6_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipId;

    private final String subnetId;

    private final String ip;

    private final String ipv6;

    private IpAddressUpdate(BuilderImpl builder) {
        this.ipId = builder.ipId;
        this.subnetId = builder.subnetId;
        this.ip = builder.ip;
        this.ipv6 = builder.ipv6;
    }

    /**
     * <p>
     * <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to
     * remove. To get this ID, use <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
     * >GetResolverEndpoint</a>.
     * </p>
     * 
     * @return <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want
     *         to remove. To get this ID, use <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
     *         >GetResolverEndpoint</a>.
     */
    public final String ipId() {
        return ipId;
    }

    /**
     * <p>
     * The ID of the subnet that includes the IP address that you want to update. To get this ID, use <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
     * >GetResolverEndpoint</a>.
     * </p>
     * 
     * @return The ID of the subnet that includes the IP address that you want to update. To get this ID, use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
     *         >GetResolverEndpoint</a>.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The new IPv4 address.
     * </p>
     * 
     * @return The new IPv4 address.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The new IPv6 address.
     * </p>
     * 
     * @return The new IPv6 address.
     */
    public final String ipv6() {
        return ipv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressUpdate)) {
            return false;
        }
        IpAddressUpdate other = (IpAddressUpdate) obj;
        return Objects.equals(ipId(), other.ipId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(ip(), other.ip()) && Objects.equals(ipv6(), other.ipv6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAddressUpdate").add("IpId", ipId()).add("SubnetId", subnetId()).add("Ip", ip())
                .add("Ipv6", ipv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpId":
            return Optional.ofNullable(clazz.cast(ipId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Ipv6":
            return Optional.ofNullable(clazz.cast(ipv6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpId", IP_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ip", IP_FIELD);
        map.put("Ipv6", IPV6_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAddressUpdate, T> g) {
        return obj -> g.apply((IpAddressUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddressUpdate> {
        /**
         * <p>
         * <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to
         * remove. To get this ID, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
         * >GetResolverEndpoint</a>.
         * </p>
         * 
         * @param ipId
         *        <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you
         *        want to remove. To get this ID, use <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
         *        >GetResolverEndpoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipId(String ipId);

        /**
         * <p>
         * The ID of the subnet that includes the IP address that you want to update. To get this ID, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
         * >GetResolverEndpoint</a>.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet that includes the IP address that you want to update. To get this ID, use <a
         *        href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html"
         *        >GetResolverEndpoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The new IPv4 address.
         * </p>
         * 
         * @param ip
         *        The new IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The new IPv6 address.
         * </p>
         * 
         * @param ipv6
         *        The new IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6(String ipv6);
    }

    static final class BuilderImpl implements Builder {
        private String ipId;

        private String subnetId;

        private String ip;

        private String ipv6;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressUpdate model) {
            ipId(model.ipId);
            subnetId(model.subnetId);
            ip(model.ip);
            ipv6(model.ipv6);
        }

        public final String getIpId() {
            return ipId;
        }

        public final void setIpId(String ipId) {
            this.ipId = ipId;
        }

        @Override
        public final Builder ipId(String ipId) {
            this.ipId = ipId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getIpv6() {
            return ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        @Override
        public IpAddressUpdate build() {
            return new IpAddressUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
