/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverQueryLogConfigsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverQueryLogConfigsResponse.Builder, ListResolverQueryLogConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverQueryLogConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(ListResolverQueryLogConfigsResponse::totalCount))
            .setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Integer> TOTAL_FILTERED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFilteredCount").getter(getter(ListResolverQueryLogConfigsResponse::totalFilteredCount))
            .setter(setter(Builder::totalFilteredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFilteredCount").build())
            .build();

    private static final SdkField<List<ResolverQueryLogConfig>> RESOLVER_QUERY_LOG_CONFIGS_FIELD = SdkField
            .<List<ResolverQueryLogConfig>> builder(MarshallingType.LIST)
            .memberName("ResolverQueryLogConfigs")
            .getter(getter(ListResolverQueryLogConfigsResponse::resolverQueryLogConfigs))
            .setter(setter(Builder::resolverQueryLogConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverQueryLogConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverQueryLogConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TOTAL_COUNT_FIELD, TOTAL_FILTERED_COUNT_FIELD, RESOLVER_QUERY_LOG_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer totalCount;

    private final Integer totalFilteredCount;

    private final List<ResolverQueryLogConfig> resolverQueryLogConfigs;

    private ListResolverQueryLogConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
        this.totalFilteredCount = builder.totalFilteredCount;
        this.resolverQueryLogConfigs = builder.resolverQueryLogConfigs;
    }

    /**
     * <p>
     * If there are more than <code>MaxResults</code> query logging configurations, you can submit another
     * <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request,
     * specify the value of <code>NextToken</code> from the previous response.
     * </p>
     * 
     * @return If there are more than <code>MaxResults</code> query logging configurations, you can submit another
     *         <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next
     *         request, specify the value of <code>NextToken</code> from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of query logging configurations that were created by the current account in the specified
     * Region. This count can differ from the number of query logging configurations that are returned in a
     * <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify in the request.
     * </p>
     * 
     * @return The total number of query logging configurations that were created by the current account in the
     *         specified Region. This count can differ from the number of query logging configurations that are returned
     *         in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify in the
     *         request.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The total number of query logging configurations that were created by the current account in the specified Region
     * and that match the filters that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the
     * total number of query logging configurations that were created by the current account in the specified Region,
     * see <code>TotalCount</code>.
     * </p>
     * 
     * @return The total number of query logging configurations that were created by the current account in the
     *         specified Region and that match the filters that were specified in the
     *         <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations
     *         that were created by the current account in the specified Region, see <code>TotalCount</code>.
     */
    public final Integer totalFilteredCount() {
        return totalFilteredCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolverQueryLogConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResolverQueryLogConfigs() {
        return resolverQueryLogConfigs != null && !(resolverQueryLogConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that
     * matches the values that you specified for <code>Filter</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolverQueryLogConfigs} method.
     * </p>
     * 
     * @return A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration
     *         that matches the values that you specified for <code>Filter</code>.
     */
    public final List<ResolverQueryLogConfig> resolverQueryLogConfigs() {
        return resolverQueryLogConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalFilteredCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasResolverQueryLogConfigs() ? resolverQueryLogConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverQueryLogConfigsResponse)) {
            return false;
        }
        ListResolverQueryLogConfigsResponse other = (ListResolverQueryLogConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCount(), other.totalCount())
                && Objects.equals(totalFilteredCount(), other.totalFilteredCount())
                && hasResolverQueryLogConfigs() == other.hasResolverQueryLogConfigs()
                && Objects.equals(resolverQueryLogConfigs(), other.resolverQueryLogConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResolverQueryLogConfigsResponse").add("NextToken", nextToken())
                .add("TotalCount", totalCount()).add("TotalFilteredCount", totalFilteredCount())
                .add("ResolverQueryLogConfigs", hasResolverQueryLogConfigs() ? resolverQueryLogConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "TotalFilteredCount":
            return Optional.ofNullable(clazz.cast(totalFilteredCount()));
        case "ResolverQueryLogConfigs":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("TotalFilteredCount", TOTAL_FILTERED_COUNT_FIELD);
        map.put("ResolverQueryLogConfigs", RESOLVER_QUERY_LOG_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResolverQueryLogConfigsResponse, T> g) {
        return obj -> g.apply((ListResolverQueryLogConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverQueryLogConfigsResponse> {
        /**
         * <p>
         * If there are more than <code>MaxResults</code> query logging configurations, you can submit another
         * <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next
         * request, specify the value of <code>NextToken</code> from the previous response.
         * </p>
         * 
         * @param nextToken
         *        If there are more than <code>MaxResults</code> query logging configurations, you can submit another
         *        <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next
         *        request, specify the value of <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of query logging configurations that were created by the current account in the specified
         * Region. This count can differ from the number of query logging configurations that are returned in a
         * <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify in the request.
         * </p>
         * 
         * @param totalCount
         *        The total number of query logging configurations that were created by the current account in the
         *        specified Region. This count can differ from the number of query logging configurations that are
         *        returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you
         *        specify in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * The total number of query logging configurations that were created by the current account in the specified
         * Region and that match the filters that were specified in the <code>ListResolverQueryLogConfigs</code>
         * request. For the total number of query logging configurations that were created by the current account in the
         * specified Region, see <code>TotalCount</code>.
         * </p>
         * 
         * @param totalFilteredCount
         *        The total number of query logging configurations that were created by the current account in the
         *        specified Region and that match the filters that were specified in the
         *        <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations
         *        that were created by the current account in the specified Region, see <code>TotalCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFilteredCount(Integer totalFilteredCount);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration
         * that matches the values that you specified for <code>Filter</code>.
         * </p>
         * 
         * @param resolverQueryLogConfigs
         *        A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging
         *        configuration that matches the values that you specified for <code>Filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigs(Collection<ResolverQueryLogConfig> resolverQueryLogConfigs);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration
         * that matches the values that you specified for <code>Filter</code>.
         * </p>
         * 
         * @param resolverQueryLogConfigs
         *        A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging
         *        configuration that matches the values that you specified for <code>Filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigs(ResolverQueryLogConfig... resolverQueryLogConfigs);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration
         * that matches the values that you specified for <code>Filter</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig.Builder#build()} is
         * called immediately and its result is passed to {@link #resolverQueryLogConfigs(List<ResolverQueryLogConfig>)}.
         * 
         * @param resolverQueryLogConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverQueryLogConfigs(java.util.Collection<ResolverQueryLogConfig>)
         */
        Builder resolverQueryLogConfigs(Consumer<ResolverQueryLogConfig.Builder>... resolverQueryLogConfigs);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer totalCount;

        private Integer totalFilteredCount;

        private List<ResolverQueryLogConfig> resolverQueryLogConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverQueryLogConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
            totalFilteredCount(model.totalFilteredCount);
            resolverQueryLogConfigs(model.resolverQueryLogConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Integer getTotalFilteredCount() {
            return totalFilteredCount;
        }

        public final void setTotalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
        }

        @Override
        public final Builder totalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
            return this;
        }

        public final List<ResolverQueryLogConfig.Builder> getResolverQueryLogConfigs() {
            List<ResolverQueryLogConfig.Builder> result = ResolverQueryLogConfigListCopier
                    .copyToBuilder(this.resolverQueryLogConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolverQueryLogConfigs(Collection<ResolverQueryLogConfig.BuilderImpl> resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs = ResolverQueryLogConfigListCopier.copyFromBuilder(resolverQueryLogConfigs);
        }

        @Override
        public final Builder resolverQueryLogConfigs(Collection<ResolverQueryLogConfig> resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs = ResolverQueryLogConfigListCopier.copy(resolverQueryLogConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigs(ResolverQueryLogConfig... resolverQueryLogConfigs) {
            resolverQueryLogConfigs(Arrays.asList(resolverQueryLogConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigs(Consumer<ResolverQueryLogConfig.Builder>... resolverQueryLogConfigs) {
            resolverQueryLogConfigs(Stream.of(resolverQueryLogConfigs)
                    .map(c -> ResolverQueryLogConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResolverQueryLogConfigsResponse build() {
            return new ListResolverQueryLogConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
