/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings for an existing Resolver on an Outpost.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutpostResolver implements SdkPojo, Serializable, ToCopyableBuilder<OutpostResolver.Builder, OutpostResolver> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(OutpostResolver::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(OutpostResolver::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(OutpostResolver::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(OutpostResolver::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(OutpostResolver::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(OutpostResolver::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> PREFERRED_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredInstanceType").getter(getter(OutpostResolver::preferredInstanceType))
            .setter(setter(Builder::preferredInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredInstanceType").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OutpostResolver::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OutpostResolver::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(OutpostResolver::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(OutpostResolver::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD, CREATOR_REQUEST_ID_FIELD, ID_FIELD, INSTANCE_COUNT_FIELD,
            PREFERRED_INSTANCE_TYPE_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, OUTPOST_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String creationTime;

    private final String modificationTime;

    private final String creatorRequestId;

    private final String id;

    private final Integer instanceCount;

    private final String preferredInstanceType;

    private final String name;

    private final String status;

    private final String statusMessage;

    private final String outpostArn;

    private OutpostResolver(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
        this.creatorRequestId = builder.creatorRequestId;
        this.id = builder.id;
        this.instanceCount = builder.instanceCount;
        this.preferredInstanceType = builder.preferredInstanceType;
        this.name = builder.name;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.outpostArn = builder.outpostArn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the Resolver on an Outpost.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the Resolver on an Outpost.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the Outpost Resolver was created, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the Outpost Resolver was created, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the Outpost Resolver was modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the Outpost Resolver was modified, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    /**
     * <p>
     * A unique string that identifies the request that created the Resolver endpoint. The <code>CreatorRequestId</code>
     * allows failed requests to be retried without the risk of running the operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request that created the Resolver endpoint. The
     *         <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the
     *         operation twice.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the Resolver on Outpost.
     * </p>
     * 
     * @return The ID of the Resolver on Outpost.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Amazon EC2 instance count for the Resolver on the Outpost.
     * </p>
     * 
     * @return Amazon EC2 instance count for the Resolver on the Outpost.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Amazon EC2 instance type.
     * </p>
     * 
     * @return The Amazon EC2 instance type.
     */
    public final String preferredInstanceType() {
        return preferredInstanceType;
    }

    /**
     * <p>
     * Name of the Resolver.
     * </p>
     * 
     * @return Name of the Resolver.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status of the Resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OutpostResolverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Resolver.
     * @see OutpostResolverStatus
     */
    public final OutpostResolverStatus status() {
        return OutpostResolverStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the Resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OutpostResolverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Resolver.
     * @see OutpostResolverStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed description of the Resolver.
     * </p>
     * 
     * @return A detailed description of the Resolver.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the Outpost.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the Outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(preferredInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostResolver)) {
            return false;
        }
        OutpostResolver other = (OutpostResolver) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime())
                && Objects.equals(creatorRequestId(), other.creatorRequestId()) && Objects.equals(id(), other.id())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(preferredInstanceType(), other.preferredInstanceType()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(outpostArn(), other.outpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutpostResolver").add("Arn", arn()).add("CreationTime", creationTime())
                .add("ModificationTime", modificationTime()).add("CreatorRequestId", creatorRequestId()).add("Id", id())
                .add("InstanceCount", instanceCount()).add("PreferredInstanceType", preferredInstanceType()).add("Name", name())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("OutpostArn", outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "PreferredInstanceType":
            return Optional.ofNullable(clazz.cast(preferredInstanceType()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("PreferredInstanceType", PREFERRED_INSTANCE_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutpostResolver, T> g) {
        return obj -> g.apply((OutpostResolver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutpostResolver> {
        /**
         * <p>
         * The ARN (Amazon Resource Name) for the Resolver on an Outpost.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the Resolver on an Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the Outpost Resolver was created, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the Outpost Resolver was created, in Unix time format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the Outpost Resolver was modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the Outpost Resolver was modified, in Unix time format and Coordinated
         *        Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);

        /**
         * <p>
         * A unique string that identifies the request that created the Resolver endpoint. The
         * <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the operation
         * twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request that created the Resolver endpoint. The
         *        <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the
         *        operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the Resolver on Outpost.
         * </p>
         * 
         * @param id
         *        The ID of the Resolver on Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Amazon EC2 instance count for the Resolver on the Outpost.
         * </p>
         * 
         * @param instanceCount
         *        Amazon EC2 instance count for the Resolver on the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Amazon EC2 instance type.
         * </p>
         * 
         * @param preferredInstanceType
         *        The Amazon EC2 instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredInstanceType(String preferredInstanceType);

        /**
         * <p>
         * Name of the Resolver.
         * </p>
         * 
         * @param name
         *        Name of the Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status of the Resolver.
         * </p>
         * 
         * @param status
         *        Status of the Resolver.
         * @see OutpostResolverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutpostResolverStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the Resolver.
         * </p>
         * 
         * @param status
         *        Status of the Resolver.
         * @see OutpostResolverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutpostResolverStatus
         */
        Builder status(OutpostResolverStatus status);

        /**
         * <p>
         * A detailed description of the Resolver.
         * </p>
         * 
         * @param statusMessage
         *        A detailed description of the Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The ARN (Amazon Resource Name) for the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String creationTime;

        private String modificationTime;

        private String creatorRequestId;

        private String id;

        private Integer instanceCount;

        private String preferredInstanceType;

        private String name;

        private String status;

        private String statusMessage;

        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostResolver model) {
            arn(model.arn);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
            creatorRequestId(model.creatorRequestId);
            id(model.id);
            instanceCount(model.instanceCount);
            preferredInstanceType(model.preferredInstanceType);
            name(model.name);
            status(model.status);
            statusMessage(model.statusMessage);
            outpostArn(model.outpostArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getPreferredInstanceType() {
            return preferredInstanceType;
        }

        public final void setPreferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
        }

        @Override
        public final Builder preferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OutpostResolverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        @Override
        public OutpostResolver build() {
            return new OutpostResolver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
