/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a Resolver configuration for a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverConfig implements SdkPojo, Serializable, ToCopyableBuilder<ResolverConfig.Builder, ResolverConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResolverConfig::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResolverConfig::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(ResolverConfig::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> AUTODEFINED_REVERSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutodefinedReverse").getter(getter(ResolverConfig::autodefinedReverseAsString))
            .setter(setter(Builder::autodefinedReverse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutodefinedReverse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ID_FIELD,
            OWNER_ID_FIELD, AUTODEFINED_REVERSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resourceId;

    private final String ownerId;

    private final String autodefinedReverse;

    private ResolverConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceId = builder.resourceId;
        this.ownerId = builder.ownerId;
        this.autodefinedReverse = builder.autodefinedReverse;
    }

    /**
     * <p>
     * ID for the Resolver configuration.
     * </p>
     * 
     * @return ID for the Resolver configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
     * </p>
     * 
     * @return The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The owner account ID of the Amazon Virtual Private Cloud VPC.
     * </p>
     * 
     * @return The owner account ID of the Amazon Virtual Private Cloud VPC.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled
     * by default. The status can be one of following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autodefinedReverse} will return {@link ResolverAutodefinedReverseStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autodefinedReverseAsString}.
     * </p>
     * 
     * @return The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
     *         enabled by default. The status can be one of following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
     *         </p>
     *         </li>
     * @see ResolverAutodefinedReverseStatus
     */
    public final ResolverAutodefinedReverseStatus autodefinedReverse() {
        return ResolverAutodefinedReverseStatus.fromValue(autodefinedReverse);
    }

    /**
     * <p>
     * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled
     * by default. The status can be one of following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autodefinedReverse} will return {@link ResolverAutodefinedReverseStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autodefinedReverseAsString}.
     * </p>
     * 
     * @return The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
     *         enabled by default. The status can be one of following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
     *         </p>
     *         </li>
     * @see ResolverAutodefinedReverseStatus
     */
    public final String autodefinedReverseAsString() {
        return autodefinedReverse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(autodefinedReverseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverConfig)) {
            return false;
        }
        ResolverConfig other = (ResolverConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(autodefinedReverseAsString(), other.autodefinedReverseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolverConfig").add("Id", id()).add("ResourceId", resourceId()).add("OwnerId", ownerId())
                .add("AutodefinedReverse", autodefinedReverseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "AutodefinedReverse":
            return Optional.ofNullable(clazz.cast(autodefinedReverseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("AutodefinedReverse", AUTODEFINED_REVERSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverConfig, T> g) {
        return obj -> g.apply((ResolverConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverConfig> {
        /**
         * <p>
         * ID for the Resolver configuration.
         * </p>
         * 
         * @param id
         *        ID for the Resolver configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
         * </p>
         * 
         * @param resourceId
         *        The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The owner account ID of the Amazon Virtual Private Cloud VPC.
         * </p>
         * 
         * @param ownerId
         *        The owner account ID of the Amazon Virtual Private Cloud VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
         * enabled by default. The status can be one of following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autodefinedReverse
         *        The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This
         *        is enabled by default. The status can be one of following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
         *        </p>
         *        </li>
         * @see ResolverAutodefinedReverseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverAutodefinedReverseStatus
         */
        Builder autodefinedReverse(String autodefinedReverse);

        /**
         * <p>
         * The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is
         * enabled by default. The status can be one of following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autodefinedReverse
         *        The status of whether or not the Resolver will create autodefined rules for reverse DNS lookups. This
         *        is enabled by default. The status can be one of following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ENABLING:</b> Autodefined rules for reverse DNS lookups are being enabled but are not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ENABLED:</b> Autodefined rules for reverse DNS lookups are enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLING:</b> Autodefined rules for reverse DNS lookups are being disabled but are not complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DISABLED:</b> Autodefined rules for reverse DNS lookups are disabled.
         *        </p>
         *        </li>
         * @see ResolverAutodefinedReverseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverAutodefinedReverseStatus
         */
        Builder autodefinedReverse(ResolverAutodefinedReverseStatus autodefinedReverse);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resourceId;

        private String ownerId;

        private String autodefinedReverse;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverConfig model) {
            id(model.id);
            resourceId(model.resourceId);
            ownerId(model.ownerId);
            autodefinedReverse(model.autodefinedReverse);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getAutodefinedReverse() {
            return autodefinedReverse;
        }

        public final void setAutodefinedReverse(String autodefinedReverse) {
            this.autodefinedReverse = autodefinedReverse;
        }

        @Override
        public final Builder autodefinedReverse(String autodefinedReverse) {
            this.autodefinedReverse = autodefinedReverse;
            return this;
        }

        @Override
        public final Builder autodefinedReverse(ResolverAutodefinedReverseStatus autodefinedReverse) {
            this.autodefinedReverse(autodefinedReverse == null ? null : autodefinedReverse.toString());
            return this;
        }

        @Override
        public ResolverConfig build() {
            return new ResolverConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
