/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation;

public class ListResolverQueryLogConfigAssociationsPublisher
implements SdkPublisher<ListResolverQueryLogConfigAssociationsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverQueryLogConfigAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverQueryLogConfigAssociationsPublisher(Route53ResolverAsyncClient client, ListResolverQueryLogConfigAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverQueryLogConfigAssociationsPublisher(Route53ResolverAsyncClient client, ListResolverQueryLogConfigAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverQueryLogConfigAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverQueryLogConfigAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations() {
        Function<ListResolverQueryLogConfigAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverQueryLogConfigAssociations() != null) {
                return response.resolverQueryLogConfigAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolverQueryLogConfigAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolverQueryLogConfigAssociationsResponseFetcher
    implements AsyncPageFetcher<ListResolverQueryLogConfigAssociationsResponse> {
        private ListResolverQueryLogConfigAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverQueryLogConfigAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverQueryLogConfigAssociationsResponse> nextPage(ListResolverQueryLogConfigAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverQueryLogConfigAssociationsPublisher.this.client.listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsPublisher.this.firstRequest);
            }
            return ListResolverQueryLogConfigAssociationsPublisher.this.client.listResolverQueryLogConfigAssociations((ListResolverQueryLogConfigAssociationsRequest)((Object)ListResolverQueryLogConfigAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

