/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.RuleTypeOption;
import software.amazon.awssdk.services.route53resolver.model.Tag;
import software.amazon.awssdk.services.route53resolver.model.TagListCopier;
import software.amazon.awssdk.services.route53resolver.model.TargetAddress;
import software.amazon.awssdk.services.route53resolver.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResolverRuleRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, CreateResolverRuleRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::creatorRequestId)).setter(CreateResolverRuleRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::name)).setter(CreateResolverRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleType").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::ruleTypeAsString)).setter(CreateResolverRuleRequest.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleType").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::domainName)).setter(CreateResolverRuleRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<TargetAddress>> TARGET_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetIps").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::targetIps)).setter(CreateResolverRuleRequest.setter(Builder::targetIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointId").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::resolverEndpointId)).setter(CreateResolverRuleRequest.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::tags)).setter(CreateResolverRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DELEGATION_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DelegationRecord").getter(CreateResolverRuleRequest.getter(CreateResolverRuleRequest::delegationRecord)).setter(CreateResolverRuleRequest.setter(Builder::delegationRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationRecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, NAME_FIELD, RULE_TYPE_FIELD, DOMAIN_NAME_FIELD, TARGET_IPS_FIELD, RESOLVER_ENDPOINT_ID_FIELD, TAGS_FIELD, DELEGATION_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResolverRuleRequest.memberNameToFieldInitializer();
    private final String creatorRequestId;
    private final String name;
    private final String ruleType;
    private final String domainName;
    private final List<TargetAddress> targetIps;
    private final String resolverEndpointId;
    private final List<Tag> tags;
    private final String delegationRecord;

    private CreateResolverRuleRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.name = builder.name;
        this.ruleType = builder.ruleType;
        this.domainName = builder.domainName;
        this.targetIps = builder.targetIps;
        this.resolverEndpointId = builder.resolverEndpointId;
        this.tags = builder.tags;
        this.delegationRecord = builder.delegationRecord;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String name() {
        return this.name;
    }

    public final RuleTypeOption ruleType() {
        return RuleTypeOption.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasTargetIps() {
        return this.targetIps != null && !(this.targetIps instanceof SdkAutoConstructList);
    }

    public final List<TargetAddress> targetIps() {
        return this.targetIps;
    }

    public final String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String delegationRecord() {
        return this.delegationRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIps() ? this.targetIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationRecord());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverRuleRequest)) {
            return false;
        }
        CreateResolverRuleRequest other = (CreateResolverRuleRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.domainName(), other.domainName()) && this.hasTargetIps() == other.hasTargetIps() && Objects.equals(this.targetIps(), other.targetIps()) && Objects.equals(this.resolverEndpointId(), other.resolverEndpointId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.delegationRecord(), other.delegationRecord());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResolverRuleRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("Name", (Object)this.name()).add("RuleType", (Object)this.ruleTypeAsString()).add("DomainName", (Object)this.domainName()).add("TargetIps", this.hasTargetIps() ? this.targetIps() : null).add("ResolverEndpointId", (Object)this.resolverEndpointId()).add("Tags", this.hasTags() ? this.tags() : null).add("DelegationRecord", (Object)this.delegationRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetIps": {
                return Optional.ofNullable(clazz.cast(this.targetIps()));
            }
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DelegationRecord": {
                return Optional.ofNullable(clazz.cast(this.delegationRecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RuleType", RULE_TYPE_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("TargetIps", TARGET_IPS_FIELD);
        map.put("ResolverEndpointId", RESOLVER_ENDPOINT_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DelegationRecord", DELEGATION_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverRuleRequest, T> g) {
        return obj -> g.apply((CreateResolverRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private String name;
        private String ruleType;
        private String domainName;
        private List<TargetAddress> targetIps = DefaultSdkAutoConstructList.getInstance();
        private String resolverEndpointId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String delegationRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverRuleRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.name(model.name);
            this.ruleType(model.ruleType);
            this.domainName(model.domainName);
            this.targetIps(model.targetIps);
            this.resolverEndpointId(model.resolverEndpointId);
            this.tags(model.tags);
            this.delegationRecord(model.delegationRecord);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleTypeOption ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<TargetAddress.Builder> getTargetIps() {
            List<TargetAddress.Builder> result = TargetListCopier.copyToBuilder(this.targetIps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetIps(Collection<TargetAddress.BuilderImpl> targetIps) {
            this.targetIps = TargetListCopier.copyFromBuilder(targetIps);
        }

        @Override
        public final Builder targetIps(Collection<TargetAddress> targetIps) {
            this.targetIps = TargetListCopier.copy(targetIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(TargetAddress ... targetIps) {
            this.targetIps(Arrays.asList(targetIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(Consumer<TargetAddress.Builder> ... targetIps) {
            this.targetIps(Stream.of(targetIps).map(c -> (TargetAddress)((TargetAddress.Builder)TargetAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDelegationRecord() {
            return this.delegationRecord;
        }

        public final void setDelegationRecord(String delegationRecord) {
            this.delegationRecord = delegationRecord;
        }

        @Override
        public final Builder delegationRecord(String delegationRecord) {
            this.delegationRecord = delegationRecord;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverRuleRequest build() {
            return new CreateResolverRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResolverRuleRequest> {
        public Builder creatorRequestId(String var1);

        public Builder name(String var1);

        public Builder ruleType(String var1);

        public Builder ruleType(RuleTypeOption var1);

        public Builder domainName(String var1);

        public Builder targetIps(Collection<TargetAddress> var1);

        public Builder targetIps(TargetAddress ... var1);

        public Builder targetIps(Consumer<TargetAddress.Builder> ... var1);

        public Builder resolverEndpointId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder delegationRecord(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

