/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverRuleAssociationResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverRuleAssociationResponse.Builder, GetResolverRuleAssociationResponse> {
    private static final SdkField<ResolverRuleAssociation> RESOLVER_RULE_ASSOCIATION_FIELD = SdkField
            .<ResolverRuleAssociation> builder(MarshallingType.SDK_POJO).memberName("ResolverRuleAssociation")
            .getter(getter(GetResolverRuleAssociationResponse::resolverRuleAssociation))
            .setter(setter(Builder::resolverRuleAssociation)).constructor(ResolverRuleAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVER_RULE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResolverRuleAssociation resolverRuleAssociation;

    private GetResolverRuleAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.resolverRuleAssociation = builder.resolverRuleAssociation;
    }

    /**
     * <p>
     * Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code>
     * request.
     * </p>
     * 
     * @return Information about the Resolver rule association that you specified in a
     *         <code>GetResolverRuleAssociation</code> request.
     */
    public final ResolverRuleAssociation resolverRuleAssociation() {
        return resolverRuleAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverRuleAssociationResponse)) {
            return false;
        }
        GetResolverRuleAssociationResponse other = (GetResolverRuleAssociationResponse) obj;
        return Objects.equals(resolverRuleAssociation(), other.resolverRuleAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResolverRuleAssociationResponse").add("ResolverRuleAssociation", resolverRuleAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRuleAssociation":
            return Optional.ofNullable(clazz.cast(resolverRuleAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResolverRuleAssociation", RESOLVER_RULE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResolverRuleAssociationResponse, T> g) {
        return obj -> g.apply((GetResolverRuleAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverRuleAssociationResponse> {
        /**
         * <p>
         * Information about the Resolver rule association that you specified in a
         * <code>GetResolverRuleAssociation</code> request.
         * </p>
         * 
         * @param resolverRuleAssociation
         *        Information about the Resolver rule association that you specified in a
         *        <code>GetResolverRuleAssociation</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleAssociation(ResolverRuleAssociation resolverRuleAssociation);

        /**
         * <p>
         * Information about the Resolver rule association that you specified in a
         * <code>GetResolverRuleAssociation</code> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolverRuleAssociation.Builder} avoiding
         * the need to create one manually via {@link ResolverRuleAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolverRuleAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #resolverRuleAssociation(ResolverRuleAssociation)}.
         * 
         * @param resolverRuleAssociation
         *        a consumer that will call methods on {@link ResolverRuleAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverRuleAssociation(ResolverRuleAssociation)
         */
        default Builder resolverRuleAssociation(Consumer<ResolverRuleAssociation.Builder> resolverRuleAssociation) {
            return resolverRuleAssociation(ResolverRuleAssociation.builder().applyMutation(resolverRuleAssociation).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverRuleAssociation resolverRuleAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverRuleAssociationResponse model) {
            super(model);
            resolverRuleAssociation(model.resolverRuleAssociation);
        }

        public final ResolverRuleAssociation.Builder getResolverRuleAssociation() {
            return resolverRuleAssociation != null ? resolverRuleAssociation.toBuilder() : null;
        }

        public final void setResolverRuleAssociation(ResolverRuleAssociation.BuilderImpl resolverRuleAssociation) {
            this.resolverRuleAssociation = resolverRuleAssociation != null ? resolverRuleAssociation.build() : null;
        }

        @Override
        public final Builder resolverRuleAssociation(ResolverRuleAssociation resolverRuleAssociation) {
            this.resolverRuleAssociation = resolverRuleAssociation;
            return this;
        }

        @Override
        public GetResolverRuleAssociationResponse build() {
            return new GetResolverRuleAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
