/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverRuleResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverRuleResponse.Builder, GetResolverRuleResponse> {
    private static final SdkField<ResolverRule> RESOLVER_RULE_FIELD = SdkField.<ResolverRule> builder(MarshallingType.SDK_POJO)
            .memberName("ResolverRule").getter(getter(GetResolverRuleResponse::resolverRule))
            .setter(setter(Builder::resolverRule)).constructor(ResolverRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResolverRule resolverRule;

    private GetResolverRuleResponse(BuilderImpl builder) {
        super(builder);
        this.resolverRule = builder.resolverRule;
    }

    /**
     * <p>
     * Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.
     * </p>
     * 
     * @return Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.
     */
    public final ResolverRule resolverRule() {
        return resolverRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverRuleResponse)) {
            return false;
        }
        GetResolverRuleResponse other = (GetResolverRuleResponse) obj;
        return Objects.equals(resolverRule(), other.resolverRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResolverRuleResponse").add("ResolverRule", resolverRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRule":
            return Optional.ofNullable(clazz.cast(resolverRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResolverRule", RESOLVER_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResolverRuleResponse, T> g) {
        return obj -> g.apply((GetResolverRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResolverRuleResponse> {
        /**
         * <p>
         * Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.
         * </p>
         * 
         * @param resolverRule
         *        Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRule(ResolverRule resolverRule);

        /**
         * <p>
         * Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolverRule.Builder} avoiding the need
         * to create one manually via {@link ResolverRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolverRule.Builder#build()} is called immediately and its
         * result is passed to {@link #resolverRule(ResolverRule)}.
         * 
         * @param resolverRule
         *        a consumer that will call methods on {@link ResolverRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverRule(ResolverRule)
         */
        default Builder resolverRule(Consumer<ResolverRule.Builder> resolverRule) {
            return resolverRule(ResolverRule.builder().applyMutation(resolverRule).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverRule resolverRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverRuleResponse model) {
            super(model);
            resolverRule(model.resolverRule);
        }

        public final ResolverRule.Builder getResolverRule() {
            return resolverRule != null ? resolverRule.toBuilder() : null;
        }

        public final void setResolverRule(ResolverRule.BuilderImpl resolverRule) {
            this.resolverRule = resolverRule != null ? resolverRule.build() : null;
        }

        @Override
        public final Builder resolverRule(ResolverRule resolverRule) {
            this.resolverRule = resolverRule;
            return this;
        }

        @Override
        public GetResolverRuleResponse build() {
            return new GetResolverRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
