/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOutpostResolversResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListOutpostResolversResponse.Builder, ListOutpostResolversResponse> {
    private static final SdkField<List<OutpostResolver>> OUTPOST_RESOLVERS_FIELD = SdkField
            .<List<OutpostResolver>> builder(MarshallingType.LIST)
            .memberName("OutpostResolvers")
            .getter(getter(ListOutpostResolversResponse::outpostResolvers))
            .setter(setter(Builder::outpostResolvers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostResolvers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutpostResolver> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutpostResolver::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOutpostResolversResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_RESOLVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<OutpostResolver> outpostResolvers;

    private final String nextToken;

    private ListOutpostResolversResponse(BuilderImpl builder) {
        super(builder);
        this.outpostResolvers = builder.outpostResolvers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutpostResolvers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutpostResolvers() {
        return outpostResolvers != null && !(outpostResolvers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that match the
     * specified filters, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutpostResolvers} method.
     * </p>
     * 
     * @return The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that
     *         match the specified filters, if any.
     */
    public final List<OutpostResolver> outpostResolvers() {
        return outpostResolvers;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> Resolvers match the specified criteria, you can submit another
     * <code>ListOutpostResolver</code> request to get the next group of results. In the next request, specify the value
     * of <code>NextToken</code> from the previous response.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> Resolvers match the specified criteria, you can submit another
     *         <code>ListOutpostResolver</code> request to get the next group of results. In the next request, specify
     *         the value of <code>NextToken</code> from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOutpostResolvers() ? outpostResolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostResolversResponse)) {
            return false;
        }
        ListOutpostResolversResponse other = (ListOutpostResolversResponse) obj;
        return hasOutpostResolvers() == other.hasOutpostResolvers()
                && Objects.equals(outpostResolvers(), other.outpostResolvers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOutpostResolversResponse")
                .add("OutpostResolvers", hasOutpostResolvers() ? outpostResolvers() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostResolvers":
            return Optional.ofNullable(clazz.cast(outpostResolvers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostResolvers", OUTPOST_RESOLVERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostResolversResponse, T> g) {
        return obj -> g.apply((ListOutpostResolversResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOutpostResolversResponse> {
        /**
         * <p>
         * The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that match
         * the specified filters, if any.
         * </p>
         * 
         * @param outpostResolvers
         *        The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that
         *        match the specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostResolvers(Collection<OutpostResolver> outpostResolvers);

        /**
         * <p>
         * The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that match
         * the specified filters, if any.
         * </p>
         * 
         * @param outpostResolvers
         *        The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that
         *        match the specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostResolvers(OutpostResolver... outpostResolvers);

        /**
         * <p>
         * The Resolvers on Outposts that were created by using the current Amazon Web Services account, and that match
         * the specified filters, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53resolver.model.OutpostResolver.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53resolver.model.OutpostResolver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53resolver.model.OutpostResolver.Builder#build()} is called
         * immediately and its result is passed to {@link #outpostResolvers(List<OutpostResolver>)}.
         * 
         * @param outpostResolvers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53resolver.model.OutpostResolver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outpostResolvers(java.util.Collection<OutpostResolver>)
         */
        Builder outpostResolvers(Consumer<OutpostResolver.Builder>... outpostResolvers);

        /**
         * <p>
         * If more than <code>MaxResults</code> Resolvers match the specified criteria, you can submit another
         * <code>ListOutpostResolver</code> request to get the next group of results. In the next request, specify the
         * value of <code>NextToken</code> from the previous response.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> Resolvers match the specified criteria, you can submit another
         *        <code>ListOutpostResolver</code> request to get the next group of results. In the next request,
         *        specify the value of <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private List<OutpostResolver> outpostResolvers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostResolversResponse model) {
            super(model);
            outpostResolvers(model.outpostResolvers);
            nextToken(model.nextToken);
        }

        public final List<OutpostResolver.Builder> getOutpostResolvers() {
            List<OutpostResolver.Builder> result = OutpostResolverListCopier.copyToBuilder(this.outpostResolvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutpostResolvers(Collection<OutpostResolver.BuilderImpl> outpostResolvers) {
            this.outpostResolvers = OutpostResolverListCopier.copyFromBuilder(outpostResolvers);
        }

        @Override
        public final Builder outpostResolvers(Collection<OutpostResolver> outpostResolvers) {
            this.outpostResolvers = OutpostResolverListCopier.copy(outpostResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostResolvers(OutpostResolver... outpostResolvers) {
            outpostResolvers(Arrays.asList(outpostResolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostResolvers(Consumer<OutpostResolver.Builder>... outpostResolvers) {
            outpostResolvers(Stream.of(outpostResolvers).map(c -> OutpostResolver.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOutpostResolversResponse build() {
            return new ListOutpostResolversResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
